package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.QuotationTemplateDetailApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.QuotationTemplateDetailApproval;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description: 报价模版明细_立项关联表
 * @Author: Rong Tao
 * @Date: 2024/3/26 18:35
 */
@RestController
@RequestMapping("/quotationTemplateDetailApproval/v1/")
@Api(tags="报价模版明细_立项关联表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QuotationTemplateDetailApprovalController extends BaseController<QuotationTemplateDetailApprovalManager, QuotationTemplateDetailApproval> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<QuotationTemplateDetailApproval>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<QuotationTemplateDetailApproval> queryFilter) {
        PageList<QuotationTemplateDetailApproval> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
