package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.manager.PurchasingRulesDetailManager;
import com.artfess.cgpt.purchasing.model.PurchasingRules;
import com.artfess.cgpt.purchasing.model.PurchasingRulesDetail;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;

/**
 * @Description:采购审批规则明细
 * @Author: Rong Tao
 * @Date: 2024/7/22 14:35
 */
@RestController
@RequestMapping("/purchasingRulesDetail/v1")
@Api(tags="采购审批规则明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PurchasingRulesDetailController extends BaseController<PurchasingRulesDetailManager, PurchasingRulesDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<PurchasingRulesDetail>> queryByPage(@RequestBody QueryFilter<PurchasingRulesDetail> queryFilter) {
        PageList<PurchasingRulesDetail> result = baseService.queryByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据（联查主表企业信息）")
    public CommonResult<PageList<PurchasingRulesDetail>> queryAllByPage(@RequestBody QueryFilter<PurchasingRulesDetail> queryFilter) {
        PageList<PurchasingRulesDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAllByOrg")
    @ApiOperation(value = "M-分页查询当前公司所有数据（联查主表企业信息）")
    public CommonResult<PageList<PurchasingRulesDetail>> pageAllByOrg(@RequestBody QueryFilter<PurchasingRulesDetail> queryFilter) {
        String orgId = ContextUtil.getCurrentOrgId();
        if(BeanUtils.isEmpty(orgId)){
            return new CommonResult<>(true, "查询成功", new PageList<>(new ArrayList<>()));
        }
        queryFilter.addFilter("b.PROCURE_ORG_ID_",orgId,QueryOP.EQUAL);
        PageList<PurchasingRulesDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
