package com.artfess.cgpt.purchasing.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;

import java.util.List;

/**
 * 采购申请表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@RestController
@RequestMapping("/purchasingApplication/v1/")
@Api(tags="采购申请")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PurchasingApplicationController extends BaseController<PurchasingApplicationManager, PurchasingApplication> {

    @Autowired
    UCFeignService ucFeignService;

    @PostMapping("/pageCurOrgData")
    @ApiOperation(value = "M-分页查询当前公司数据（管理员查看所有）")
    public CommonResult<PageList<PurchasingApplication>> pageCurOrgData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        BizUtils.addFilterByUserOrgAndRoleBusiness(queryFilter,ucFeignService,"PREPARED_ORG_ID_");
        PageList<PurchasingApplication> result = baseService.curOrgData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/curUserData")
    @ApiOperation(value = "M-分页查询当前用户的数据")
    public CommonResult<PageList<PurchasingApplication>> curUserData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("PREPARED_USER_ID_", ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        PageList<PurchasingApplication> result = baseService.curOrgData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/curOrgData")
    @ApiOperation(value = "M-分页查询当前公司数据")
    public CommonResult<PageList<PurchasingApplication>> curOrgData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        queryFilter.addFilter("PREPARED_ORG_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        PageList<PurchasingApplication> result = baseService.curOrgData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<PurchasingApplication>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<PurchasingApplication> queryFilter) {
        PageList<PurchasingApplication> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-批量删除")
    public CommonResult remove(@RequestParam List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-根据ID查询详情")
    public CommonResult<PurchasingApplication> selectOne(@RequestParam("id") String id){
        PurchasingApplication result = baseService.getDataById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdate(@RequestBody PurchasingApplication entity){
        String id = baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true,"操作成功",id);
    }

    @PostMapping("/updateStatus")
    @ApiOperation(value = "M-根据ID更新状态")
    public CommonResult updateStatus(@RequestParam("ids") String ids,@RequestParam("status") String status){
        baseService.updateStatus(ids,status);
        return new CommonResult<>(true,"操作成功",ids);
    }

    @PostMapping("/modifyStatusById")
    @ApiOperation(value = "M-根据ID修改状态（只修改状态）")
    public CommonResult modifyStatusById(@RequestParam("ids") String ids,@RequestParam("status") String status){
        baseService.modifyStatusById(ids,status);
        return new CommonResult<>(true,"操作成功",ids);
    }

}
