package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.MatApprovalQualificationManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalQualification;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:采购立项_资质标签关联表
 * @Author: Rong Tao
 * @Date: 2024/6/25 16:14
 */
@RestController
@RequestMapping("/matApprovalQualification/v1/")
@Api(tags="物料采购立项表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MatApprovalQualificationController extends BaseController<MatApprovalQualificationManager, MatApprovalQualification> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<MatApprovalQualification>> queryAllByPage(@RequestBody QueryFilter<MatApprovalQualification> queryFilter) {
        PageList<MatApprovalQualification> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
