package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 10:26
 */
@RestController
@RequestMapping("/matApprovalDetails/v1/")
@Api(tags="物料采购立项明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class MatApprovalDetailsController extends BaseController<MatApprovalDetailsManager, MatApprovalDetails> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<MatApprovalDetails>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApprovalDetails> queryFilter) {
        PageList<MatApprovalDetails> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageEvaDetail")
    @ApiOperation(value = "M-评标管理-分页查询所有明细数据（带评标标识）")
    public CommonResult<PageList<MatApprovalDetails>> pageEvaDetail(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApprovalDetails> queryFilter) {
        PageList<MatApprovalDetails> result = baseService.pageEvaDetail(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/quoData")
    @ApiOperation(value = "M-报价明细")
    public CommonResult<MatApproval> quoData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApprovalDetails> queryFilter) {
        MatApproval result = baseService.quoData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/quoManageData")
    @ApiOperation(value = "M-报价管理-明细")
    public CommonResult<MatApproval> quoManageData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApprovalDetails> queryFilter) {
        MatApproval result = baseService.quoManageData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/bidOpenManageData")
    @ApiOperation(value = "M-开标管理-报价明细")
    public CommonResult<PageList<MatApprovalDetails>> bidOpenManageData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApprovalDetails> queryFilter) {
        PageList<MatApprovalDetails> result = baseService.bidOpenManageData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageEvaData")
    @ApiOperation(value = "M-分页查询评标明细")
    public CommonResult<PageList<MatApprovalDetails>> pageEvaData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<MatApprovalDetails> queryFilter) {
        PageList<MatApprovalDetails> result = baseService.pageEvaData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    /**
     * 根据Excel文件转换数据（采购立项明细）
     * @param file Excel文件
     */
    @PostMapping("/excelToData")
    @ApiOperation(value = "M-根据Excel文件转换数据（采购立项明细）")
    public CommonResult<List<MatApprovalDetails>> excelToData(@RequestParam("file") MultipartFile file) throws Exception{
        List<MatApprovalDetails> result = baseService.excelToData(file);
        return new CommonResult<>(true,"操作成功",result);
    }

    /**
     * 根据Excel文件转换数据（报价模版导入）
     * @param file Excel文件
     */
    @PostMapping("/excelTemplateToData")
    @ApiOperation(value = "M-根据Excel文件转换数据（报价模版导入）")
    public CommonResult<List<Map<String, String>>> excelTemplateToData(@RequestParam("file") MultipartFile file) {
        List<Map<String, String>> result = baseService.excelTemplateToData(file);
        return new CommonResult<>(true,"操作成功",result);
    }

    /**
     * 导出报价模版到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportTemplateToExcel")
    @ApiOperation(value = "M-导出报价模版到Excel",notes = "参数说明：和查询参数一样")
    public CommonResult exportTemplateToExcel (@RequestBody QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws Exception {
        baseService.exportTemplateToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "M-导出数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws IOException {
        baseService.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    /**
     * 导出评标数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportEvaDataToExcel")
    @ApiOperation(value = "M-导出评标数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要")
    public CommonResult exportEvaDataToExcel(@RequestBody QueryFilter<MatApprovalDetails> queryFilter, HttpServletResponse response) throws IOException {
        baseService.exportEvaDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

}
