package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.purchasing.model.MatApprovalQualification;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 参与报名表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@ApiModel(value="UserParticipation对象", description="参与报名表")
@TableName("biz_user_participation")
@Data
public class UserParticipation extends BizModel<UserParticipation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "用户ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "用户账号")
    @TableField("USER_ACCOUNT_")
    private String userAccount;

    @ApiModelProperty(value = "用户姓名")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "联系方式")
    @TableField("USER_PHONE_")
    private String userPhone;

    @ApiModelProperty(value = "参与时间")
    @TableField("PARTICIPATION_DATE_")
    private LocalDateTime participationDate;

    @ApiModelProperty(value = "用户所属公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "用户所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "用户所属公司编码")
    @TableField("COMPANY_CODE_")
    private String companyCode;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "状态（1：已参与，2：审核中，3.待支付，4.已支付，5.已取消，6.审核未通过），默认1")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "金额（元）")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "费用类型（1.保证金，2.标书费），默认1")
    @TableField("TYPE_")
    private Integer type;

    @ApiModelProperty(value = "支付订单ID（关联支付订单ID）")
    @TableField("REGISTRATION_ORDER_ID_")
    private String registrationOrderId;

    @ApiModelProperty(value = "订单号（关联支付订单号））")
    @TableField("REGISTRATION_ORDER_NUMBER_")
    private String registrationOrderNumber;

    @ApiModelProperty(value = "退款订单ID（关联支付订单ID）")
    @TableField("REFUND_REGISTRATION_ORDER_ID_")
    private String refundRegistrationOrderId;

    @ApiModelProperty(value = "退款订单号（关联支付订单号）")
    @TableField("REFUND_REGISTRATION_ORDER_NUMBER_")
    private String refundRegistrationOrderNumber;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "资质库集合")
    @TableField(exist = false)
    private List<BizQualificationLabel> qualificationLabelList;

    @ApiModelProperty(value = "是否报价（0.未报价，1.已报价）")
    @TableField(exist = false)
    private Integer isQuo;

    @ApiModelProperty(value = "成交通知id")
    @TableField(exist = false)
    private String winNoticeId;

    @ApiModelProperty(value = "标书费")
    @TableField(exist = false)
    private BigDecimal documentFee;

    @ApiModelProperty(value = "标书费记录ID")
    @TableField("DOCUMENT_FEE_ID_")
    private String documentFeeId;

    @ApiModelProperty(value = "立项_资质标签关联表集合")
    @TableField(exist = false)
    private List<MatApprovalQualification> matApprovalQualificationList;

}
