package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * @Description:项目台帐表
 * @Author: Rong Tao
 * @Date: 2024/5/21 16:11
 */
@ApiModel(value="ProjectLedger对象", description="项目台帐表")
@TableName("biz_project_ledger")
@Data
public class ProjectLedger extends BizModel<ProjectLedger> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目编号")
    @TableField("PROJECT_CODE_")
    private String projectCode;

    @ApiModelProperty(value = "项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "所属年度")
    @TableField("YEAR_")
    private Integer year;

    @ApiModelProperty(value = "项目类型（1.服务，2.工程）")
    @TableField("PROJECT_TYPE_")
    private Integer projectType;

    @ApiModelProperty(value = "项目负责人ID")
    @TableField("PROJECT_USER_ID_")
    private String projectUserId;

    @ApiModelProperty(value = "项目负责人姓名")
    @TableField("PROJECT_USER_NAME_")
    private String projectUserName;

    @ApiModelProperty(value = "项目负责人联系电话")
    @TableField("PROJECT_USER_MOBILE_")
    private String projectUserMobile;

    @ApiModelProperty(value = "采购单位ID")
    @TableField("PURCHASING_ORG_ID_")
    private String purchasingOrgId;

    @ApiModelProperty(value = "采购单位编号")
    @TableField("PURCHASING_ORG_CODE_")
    private String purchasingOrgCode;

    @ApiModelProperty(value = "采购单位名称")
    @TableField("PURCHASING_ORG_NAME_")
    private String purchasingOrgName;

    @ApiModelProperty(value = "总投资（万元）")
    @TableField("INVESTMENT_")
    private BigDecimal investment;

    @ApiModelProperty(value = "建设开始时间")
    @TableField("CONSTRUCTION_START_TIME_")
    private LocalDate constructionStartTime;

    @ApiModelProperty(value = "建设结束时间")
    @TableField("CONSTRUCTION_COMPLETION_TIME_")
    private LocalDate constructionCompletionTime;

    @ApiModelProperty(value = "项目状态（1.立项、2.在建、3.竣工 、4.终止）")
    @TableField("PROJECT_STATUS_")
    private Integer projectStatus;

    @ApiModelProperty(value = "项目描述")
    @TableField("PROJECT_DESCRIPT_")
    private String projectDescript;

    @ApiModelProperty(value = "业务状态（1：未制单，2.已制单）")
    @TableField("BIZ_STATUS_")
    private Integer bizStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "设备明细")
    @TableField(exist = false)
    private List<EquipmentProjectDetail> equipmentDetailList;

    @ApiModelProperty(value = "服务明细")
    @TableField(exist = false)
    private List<ServiceProjectDetail> serviceDetailList;

    @ApiModelProperty(value = "工程明细")
    @TableField(exist = false)
    private List<EngineeringProjectDetail> engineeringDetailList;

//    @ApiModelProperty(value = "附件集合")
//    @TableField(exist = false)
//    private List<Accessory> accessoryList;

}
