package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/27 18:24
 */
@ApiModel(value="ProjectApprovalPay对象", description="项目采购立项付款信息表")
@TableName("biz_project_approval_pay")
@Data
public class ProjectApprovalPay extends BizNoModel<ProjectApprovalPay> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项ID（关联项目立项表ID）")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "明细类型（1.服务，2.工程，3.设备）")
    @TableField("DETAIL_TYPE_")
    private Integer detailType;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项ID（关联项目立项表ID）")
    @TableField("NOTICE_DETAIL_ID_")
    private String noticeDetailId;

    @ApiModelProperty(value = "费用名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "付款条件")
    @TableField("PAY_TERM_")
    private String payTerm;

    @ApiModelProperty(value = "服务范围")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "服务内容")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "开始时间")
    @TableField("SERVICE_START_TIME_")
    private LocalDate serviceStartTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("SERVICE_END_TIME_")
    private LocalDate serviceEndTime;

    @ApiModelProperty(value = "付款次数（当前第几次付款）")
    @TableField("PAY_FREQUENCY_")
    private Integer payFrequency;

    @ApiModelProperty(value = "付款比例（%）")
    @TableField("PAY_RATIO_")
    private Integer payRatio;

    @ApiModelProperty(value = "付款金额")
    @TableField("PAY_AMOUNT_")
    private BigDecimal payAmount;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "最高限价")
    @TableField("MAXIMUM_PRICE_LIMIT_")
    private BigDecimal maximumPriceLimit;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

}
