package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.purchasing.model.*;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.annotation.IdType;

import java.math.BigDecimal;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目采购立项表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-12
 */
@ApiModel(value="ProjectApproval对象", description="项目采购立项表")
@TableName("biz_project_approval")
@Data
public class ProjectApproval extends BizModel<ProjectApproval> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项编号（自动生成）")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项内容")
    @TableField("ESTABLISHMENT_NAME_")
    private String establishmentName;

    @ApiModelProperty(value = "组织人ID")
    @TableField("AFFILIATED_USER_ID_")
    private String affiliatedUserId;

    @ApiModelProperty(value = "组织人联系方式")
    @TableField("CONTACTS_PHONE_")
    private String contactsPhone;

    @ApiModelProperty(value = "组织人姓名")
    @TableField("AFFILIATED_USER_NAME_")
    private String affiliatedUserName;

    @ApiModelProperty(value = "组织公司ID")
    @TableField("AFFILIATED_ORG_ID_")
    private String affiliatedOrgId;

    @ApiModelProperty(value = "组织公司编码")
    @TableField("AFFILIATED_ORG_CODE_")
    private String affiliatedOrgCode;

    @ApiModelProperty(value = "组织公司名称")
    @TableField("AFFILIATED_ORG_NAME_")
    private String affiliatedOrgName;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("PROCURE_ORG_ID_")
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField("PROCURE_ORG_CODE_")
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("PROCURE_ORG_NAME_")
    private String procureOrgName;

    @ApiModelProperty(value = "编制时间")
    @TableField("AFFILIATED_DATE_")
    private LocalDateTime affiliatedDate;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "发布方式（1.公开，2.邀请）")
    @TableField("RELEASE_METHOD_")
    private Integer releaseMethod;

    @ApiModelProperty(value = "采购类型（1：公开招标，2：询比价，3：限时竞价，4：份额采购（谈判），"
            +"5：单一来源，6：比选（多轮竞价），7：公开邀请）")
    @TableField("PROCURE_TYPE_")
    private Integer procureType;

    @ApiModelProperty(value = "有无资质要求（1：无，2：有）")
    @TableField("HAS_QUALIFICATION_")
    private Integer hasQualification;

    @ApiModelProperty(value = "分项中标（0：否，1：是）")
    @TableField("HAS_SUBPACKAGE_")
    private Integer hasSubpackage;

    @ApiModelProperty(value = "有无保证金（0：无，1：有）")
    @TableField("HAS_BOND_")
    private Integer hasBond;

    @ApiModelProperty(value = "保证金（元）")
    @TableField("BOND_")
    private BigDecimal bond;

    @ApiModelProperty(value = "保函_文件URL")
    @TableField("BOND_FILE_URL_")
    private String bondFileUrl;

    @ApiModelProperty(value = "报价方式（1：现金，2：承兑）")
    @TableField("QUOTATION_METHOD_")
    private Integer quotationMethod;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

    @ApiModelProperty(value = "资质要求内容（下拉多选，当有无资质要求为有时必须选择）")
    @TableField("QUALIFICATIONS_COUTENT_")
    private String qualificationsCoutent;

    @ApiModelProperty(value = "公告发布时间")
    @TableField("NOTICE_RELEASE_TIME_")
    private LocalDateTime noticeReleaseTime;

    @ApiModelProperty(value = "供货商提出问题的截止时间")
    @TableField("RAISING_QUESTIONS_DEADLINE_TIME_")
    private LocalDateTime raisingQuestionsDeadlineTime;

    @ApiModelProperty(value = "澄清补遗截止时间")
    @TableField("CLARIFICATION_SUPPLEMENT_DEADLINE_TIME_")
    private LocalDateTime clarificationSupplementDeadlineTime;

    @ApiModelProperty(value = "响应截止时间")
    @TableField("RESPONSE_TIME_DEADLINE_")
    private LocalDateTime responseTimeDeadline;

    @ApiModelProperty(value = "投标开始时间")
    @TableField("BIDDING_START_TIME_")
    private LocalDateTime biddingStartTime;

    @ApiModelProperty(value = "投标结束时间")
    @TableField("BIDDING_END_TIME_")
    private LocalDateTime biddingEndTime;

    @ApiModelProperty(value = "公告下架时间")
    @TableField("NOTICE_OFF_TIME_")
    private LocalDateTime noticeOffTime;

    @ApiModelProperty(value = "评标开始时间")
    @TableField("EVALUATION_START_TIME_")
    private LocalDateTime evaluationStartTime;

    @ApiModelProperty(value = "评标结束时间")
    @TableField("EVALUATION_END_TIME_")
    private LocalDateTime evaluationEndTime;

    @ApiModelProperty(value = "立项类型（1：服务，2：工程）")
    @TableField("APPLICATION_TYPE_")
    private Integer applicationType;

    @ApiModelProperty(value = "报价模版ID")
    @TableField("QUOTATION_TEMPLATE_")
    private String quotationTemplate;

    @ApiModelProperty(value = "报价模版名称")
    @TableField("QUOTATION_TEMPLATE_NAME_")
    private String quotationTemplateName;

    @ApiModelProperty(value = "评标方式（1.以物料评标，2.以供应商评标）")
    @TableField("EVALUATION_MODE_")
    private Integer evaluationMode;

    @ApiModelProperty(value = "评标方法（1.最低价评标法，2.综合评标法）")
    @TableField("EVALUATION_METHOD_")
    private Integer evaluationMethod;

    @ApiModelProperty(value = "评标模版ID")
    @TableField("EVALUATION_TEMPLATE_ID_")
    private String evaluationTemplateId;

    @ApiModelProperty(value = "报价轮数（立项时设置可以进行几轮报价），默认1")
    @TableField("QUOTATION_ROUNDS_")
    private Integer quotationRounds;
    @ApiModelProperty(value = "报价轮次（当前第几次报价），默认1")
    @TableField("QUOTATION_ROUNDS_NUM_")
    private Integer quotationRoundsNum;

    @ApiModelProperty(value = "新一轮报价原因")
    @TableField("NEW_QUO_REASON_")
    private String newQuoReason;

    @ApiModelProperty(value = "流标原因")
    @TableField("FAIL_BID_REASON_")
    private String failBidReason;

    @ApiModelProperty(value = "项目状态（0：草稿，1：审批中，2：已立项，3：已发布，4：未开标，"
            +"5：已开标，6：已评标，7：已中标，8：流标，9：已发布成交公示，"
            +"10：定标，11：已发布成交通知）")
    @TableField("BID_STATUS_")
    private Integer bidStatus;

    @ApiModelProperty(value = "发布状态（0：草稿，1：审批中，2：已发布，3：已下架，4.审批驳回），默认0")
    @TableField("RELEASE_STATUS_")
    private Integer releaseStatus;

    @ApiModelProperty(value = "资格审查方式（1.资格后审招标，2.资格预审招标）")
    @TableField("QUALIFICATION_METHOD_")
    private Integer qualificationMethod;

    @ApiModelProperty(value = "是否重复生成合同（0.否，1.是）")
    @TableField("GENERATE_DUPLICATE_CONTRACTS_")
    private Integer generateDuplicateContracts;

    @ApiModelProperty(value = "中标结果有效期（天）")
    @TableField("WIN_BID_VALIDITY")
    private Integer winBidValidity;

    @ApiModelProperty(value = "定标状态（0：未审批，1：定标审批中，2：已定标）")
    @TableField("CALIBRA_STATUS_")
    private Integer calibraStatus;

    @ApiModelProperty(value = "成交通知发布状态（1.未发布，2.已发布（已确认），3.待确认，4：不同意），默认1")
    @TableField("WIN_NOTICE_STATUS_")
    private Integer winNoticeStatus;

    @ApiModelProperty(value = "成交公示发布状态（1.未发布，2.审核中，3.已发布），默认1")
    @TableField("PUBLICITY_STATUS_")
    private Integer publicityStatus;

    @ApiModelProperty(value = "投标文件是否必传（0：否，1：是），默认0")
    @TableField("IS_BID_DOCUMENTS_UPLOAD_")
    private Integer isBidDocumentsUpload;

    @ApiModelProperty(value = "明细来源类型（1.项目库引入，2.项目申请引入），默认1")
    @TableField("PROJECT_SOURCE_TYPE_")
    private Integer projectSourceType;

    @ApiModelProperty(value = "评标专家数量")
    @TableField("EVALUATION_EXPERT_NUMBER_")
    private Integer evaluationExpertNumber;

    @ApiModelProperty(value = "项目申请ID（关联项目申请表ID）")
    @TableField("PROJECT_INFO_ID_")
    private String projectInfoId;

    @ApiModelProperty(value = "项目库ID（关联项目库ID）")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "项目库编号（关联项目库编号）")
    @TableField("PROJECT_LEDGER_CODE_")
    private String projectLedgerCode;

    @ApiModelProperty(value = "项目名称（关联项目库名称）")
    @TableField("PROJECT_LEDGER_NAME_")
    private String projectLedgerName;

    @ApiModelProperty(value = "成交通知发布时间")
    @TableField("WIN_NOTICE_TIME_")
    private LocalDateTime winNoticeTime;

    @ApiModelProperty(value = "成交有效期截止时间")
    @TableField("WIN_BID_VALIDITY_TIME_")
    private LocalDateTime winBidValidityTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "预算类型（1.有采购包或标段预算，2.仅有整体项目预算，3.有预估采购规模，4.无预算），默认4")
    @TableField("FUND_TYPE_")
    private Integer fundType;

    @ApiModelProperty(value = "采购包或标段预算/规模（元），明细最高限价总额，默认0")
    @TableField("FUND_SCALE_")
    private BigDecimal fundScale;

    @ApiModelProperty(value = "技术权重（技术总分）")
    @TableField("TECHNICAL_WEIGHT_")
    private BigDecimal technicalWeight;

    @ApiModelProperty(value = "商务权重（商务总分）")
    @TableField("BUSINESS_WEIGHT_")
    private BigDecimal businessWeight;

    @ApiModelProperty(value = "招标类型（1：物料，2：项目），默认2")
    @TableField("NOTICE_TYPE_")
    private String noticeType;

    @ApiModelProperty(value = "标书费（元），默认0")
    @TableField("DOCUMENT_FEE_")
    private BigDecimal documentFee;


    @ApiModelProperty(value = "付款次数（默认3）")
    @TableField("PAY_FREQUENCY_")
    private Integer payFrequency;

    @ApiModelProperty(value = "第一次付款比例")
    @TableField("PAY_RATIO_1_")
    private BigDecimal payRatio1;

    @ApiModelProperty(value = "第二次付款比例")
    @TableField("PAY_RATIO_2_")
    private BigDecimal payRatio2;

    @ApiModelProperty(value = "第三次付款比例")
    @TableField("PAY_RATIO_3_")
    private BigDecimal payRatio3;

    @ApiModelProperty(value = "第四次付款比例")
    @TableField("PAY_RATIO_4_")
    private BigDecimal payRatio4;

    @ApiModelProperty(value = "第五次付款比例")
    @TableField("PAY_RATIO_5_")
    private BigDecimal payRatio5;


    @ApiModelProperty(value ="项目采购立项明细集合")
    @TableField(exist = false)
    private List<ProjectApprovalDetails> detailsList;

    @ApiModelProperty(value = "报价模版明细立项关联数据")
    @TableField(exist = false)
    private List<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalList;

    @ApiModelProperty(value = "招标文件")
    @TableField(exist = false)
    private TenderDocument zbDocument;

    @ApiModelProperty(value = "补遗文件")
    @TableField(exist = false)
    private List<TenderDocument> byDocument;

    @ApiModelProperty(value = "评标专家")
    @TableField(exist = false)
    private List<ProjectEvaluationExpert> projectEvaluationExpertList;

    @ApiModelProperty(value = "参与状态（1：已参与，2：审核中，3.待支付，4.已支付，5.已取消，6.未参与）")
    @TableField(exist = false)
    private Integer joinStatus;

    @ApiModelProperty(value = "参与表ID")
    @TableField(exist = false)
    private String partId;

    @ApiModelProperty(value = "报价数据集合")
    @TableField(exist = false)
    private List<BizBiddingQuotation> quotationList;

    @ApiModelProperty(value = "邀请供应商集合")
    @TableField(exist = false)
    private List<ApprovalInviteVendor> approvalInviteVendorList;

    @ApiModelProperty(value = "评标模版")
    @TableField(exist = false)
    private BizEvaluationSystem evaTemplate;

    @ApiModelProperty(value = "是否报价（0.未报价，1.已报价）")
    @TableField(exist = false)
    private Integer isQuo;

    @ApiModelProperty(value = "立项_资质标签关联表集合")
    @TableField(exist = false)
    private List<MatApprovalQualification> matApprovalQualificationList;

    @ApiModelProperty(value = "组织人账号")
    @TableField("NOTICE_RELEASE_USER_ACCOUNT_")
    private String noticeReleaseUserAccount;


//    @ApiModelProperty(value = "付款信息集合")
//    @TableField(exist = false)
//    private List<ProjectApprovalPay> payInfoList;

}
