package com.artfess.cgpt.project.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.project.dao.ProjectLedgerDao;
import com.artfess.cgpt.project.manager.EngineeringProjectDetailManager;
import com.artfess.cgpt.project.manager.EquipmentProjectDetailManager;
import com.artfess.cgpt.project.manager.ProjectLedgerManager;
import com.artfess.cgpt.project.manager.ServiceProjectDetailManager;
import com.artfess.cgpt.project.model.EngineeringProjectDetail;
import com.artfess.cgpt.project.model.ProjectLedger;
import com.artfess.cgpt.project.model.EquipmentProjectDetail;
import com.artfess.cgpt.project.model.ServiceProjectDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/5/21 16:15
 */
@Service
public class ProjectLedgerManagerImpl extends BaseManagerImpl<ProjectLedgerDao, ProjectLedger> implements ProjectLedgerManager {

    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private EquipmentProjectDetailManager equipmentDetailManager;
    @Autowired
    private ServiceProjectDetailManager serviceDetailManager;
    @Autowired
    private EngineeringProjectDetailManager engineeringDetailManager;
    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<ProjectLedger> queryAllByPage(QueryFilter<ProjectLedger> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<ProjectLedger> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(ProjectLedger entity) {

        List<EquipmentProjectDetail> equipmentDetailList = entity.getEquipmentDetailList();
        List<EngineeringProjectDetail> engineeringDetailList = entity.getEngineeringDetailList();
        List<ServiceProjectDetail> serviceDetailList = entity.getServiceDetailList();

        if(BeanUtils.isNotEmpty(entity.getId())){
            //清除历史明细
            if(entity.getProjectType().equals(1)){
                //服务类
                LambdaQueryWrapper<ServiceProjectDetail> serviceDetailQW = new LambdaQueryWrapper<>();
                serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId,entity.getId());
                serviceDetailManager.remove(serviceDetailQW);
            }else {
                LambdaQueryWrapper<EngineeringProjectDetail> engineeringDetailQW = new LambdaQueryWrapper<>();
                engineeringDetailQW.eq(EngineeringProjectDetail::getProjectLedgerId,entity.getId());
                engineeringDetailManager.remove(engineeringDetailQW);
                LambdaQueryWrapper<EquipmentProjectDetail> equipmentDetailQW = new LambdaQueryWrapper<>();
                equipmentDetailQW.eq(EquipmentProjectDetail::getProjectLedgerId,entity.getId());
                equipmentDetailManager.remove(equipmentDetailQW);
                LambdaQueryWrapper<ServiceProjectDetail> serviceDetailQW = new LambdaQueryWrapper<>();
                serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId,entity.getId());
                serviceDetailManager.remove(serviceDetailQW);
            }
        }else {
            if(BeanUtils.isEmpty(entity.getProjectCode())){
                entity.setProjectCode(BizUtils.getNextSerialNumber(systemConfigFeignService, "xmxx_xmbh"));
            }
        }

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(equipmentDetailList) && equipmentDetailList.size()>0){
            equipmentDetailList.stream().forEach(s->s.setProjectLedgerId(entity.getId()));
            equipmentDetailManager.saveBatch(equipmentDetailList);
        }
        if(BeanUtils.isNotEmpty(engineeringDetailList) && engineeringDetailList.size()>0){
            engineeringDetailList.stream().forEach(s->s.setProjectLedgerId(entity.getId()));
            engineeringDetailManager.saveBatch(engineeringDetailList);
        }
        if(BeanUtils.isNotEmpty(serviceDetailList) && serviceDetailList.size()>0){
            serviceDetailList.stream().forEach(s->s.setProjectLedgerId(entity.getId()));
            serviceDetailManager.saveBatch(serviceDetailList);
        }

    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        //1.删除子表
        LambdaQueryWrapper<EquipmentProjectDetail> equipmentDetailQW = new LambdaQueryWrapper<>();
        equipmentDetailQW.in(EquipmentProjectDetail::getProjectLedgerId,ids);
        equipmentDetailManager.remove(equipmentDetailQW);
        LambdaQueryWrapper<EngineeringProjectDetail> engineeringDetailQW = new LambdaQueryWrapper<>();
        engineeringDetailQW.in(EngineeringProjectDetail::getProjectLedgerId,ids);
        engineeringDetailManager.remove(engineeringDetailQW);
        LambdaQueryWrapper<ServiceProjectDetail> serviceDetailQW = new LambdaQueryWrapper<>();
        serviceDetailQW.in(ServiceProjectDetail::getProjectLedgerId,ids);
        serviceDetailManager.remove(serviceDetailQW);

        //2.删除主表
        super.removeByIds(ids);
    }

    @Override
    public ProjectLedger getDataById(String id) {
        ProjectLedger result = super.getById(id);

        if(result.getProjectType().equals(1)){
            //服务类
            LambdaQueryWrapper<ServiceProjectDetail> serviceDetailQW = new LambdaQueryWrapper<>();
            serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId,id);
            result.setServiceDetailList(serviceDetailManager.list(serviceDetailQW));
        }else {
            LambdaQueryWrapper<EquipmentProjectDetail> equipmentDetailQW = new LambdaQueryWrapper<>();
            equipmentDetailQW.eq(EquipmentProjectDetail::getProjectLedgerId,id);
            result.setEquipmentDetailList(equipmentDetailManager.list(equipmentDetailQW));

            LambdaQueryWrapper<EngineeringProjectDetail> engineeringDetailQW = new LambdaQueryWrapper<>();
            engineeringDetailQW.eq(EngineeringProjectDetail::getProjectLedgerId,id);
            result.setEngineeringDetailList(engineeringDetailManager.list(engineeringDetailQW));

            LambdaQueryWrapper<ServiceProjectDetail> serviceDetailQW = new LambdaQueryWrapper<>();
            serviceDetailQW.eq(ServiceProjectDetail::getProjectLedgerId,id);
            result.setServiceDetailList(serviceDetailManager.list(serviceDetailQW));
        }

        return result;
    }

}
