package com.artfess.cgpt.project.dao;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 物料/项目采购立项表，物料和项目采购立项主表都走此表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-11
 */
public interface ProjectApprovalDao extends BaseMapper<ProjectApproval> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<ProjectApproval> queryAllByPage(IPage<ProjectApproval> convert2IPage, @Param("ew") Wrapper<ProjectApproval> convert2Wrapper);

    /**
     * 查询所有数据ID
     * @param convert2Wrapper
     * @return
     */
    List<String> queryIds(@Param("ew") Wrapper<ProjectApproval> convert2Wrapper);

    /**
     * 参与报名-分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<ProjectApproval> getSignData(IPage<ProjectApproval> convert2IPage,
                                       @Param("ew") Wrapper<ProjectApproval> convert2Wrapper);

    /**
     * 我的报价-分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<ProjectApproval> getQuoData(IPage<ProjectApproval> convert2IPage,@Param("ew") Wrapper<ProjectApproval> convert2Wrapper);

}
