package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.EngineeringProjectDetailManager;
import com.artfess.cgpt.project.model.EngineeringProjectDetail;
import com.artfess.cgpt.project.model.EquipmentProjectDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:工程项目明细表
 * @Author: Rong Tao
 * @Date: 2024/5/24 15:48
 */
@RestController
@RequestMapping("/engineeringProjectDetail/v1/")
@Api(tags="工程项目明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class EngineeringProjectDetailController extends BaseController<EngineeringProjectDetailManager, EngineeringProjectDetail> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<EngineeringProjectDetail>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<EngineeringProjectDetail> queryFilter) {
        PageList<EngineeringProjectDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}