package com.artfess.cgpt.order.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户报名订单项目明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@ApiModel(value="BizUserApplicationProjectDetails对象", description="用户报名订单项目明细表")
public class BizUserApplicationProjectDetails extends BaseModel<BizUserApplicationProjectDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "用户ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "用户账号")
    @TableField("USER_ACCOUNT_")
    private String userAccount;

    @ApiModelProperty(value = "用户姓名")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "用户所属公司编码")
    @TableField("COMPANY_CODE_")
    private String companyCode;

    @ApiModelProperty(value = "联系方式")
    @TableField("USER_PHONE_")
    private String userPhone;

    @ApiModelProperty(value = "用户所属公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "报名时间")
    @TableField("APPLICATION_DATE_")
    private LocalDateTime applicationDate;

    @ApiModelProperty(value = "用户所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_NUMBER_")
    private String noticeNumber;

    @ApiModelProperty(value = "报名状态（使用字典，1：审核中，2：审核已通过，3：审核未通过，4：已报名，5：已取消））")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "项目ID（关联项目基本信息表ID）")
    @TableField("PROJECT_ID_")
    private String projectId;

    @ApiModelProperty(value = "项目编号")
    @TableField("PROJECT_CODE_")
    private String projectCode;

    @ApiModelProperty(value = "项目名称")
    @TableField("PROJECT_NAME_")
    private String projectName;

    @ApiModelProperty(value = "项目金额(万元)")
    @TableField("PROJECT_MONEY_")
    private BigDecimal projectMoney;

    @ApiModelProperty(value = "建设模式（使用字典，1：自建，2：委托代建，3：BT模式，4：BOT模式，5：BOOT模式，6：BOOT模式，7：BOO模式，8：BLT模式，9：TOT模式，10：ROT模式，11：O&M模式，12：MC模式，13：其它）")
    @TableField("PROJECT_MODEL_")
    private String projectModel;

    @ApiModelProperty(value = "项目类型（使用字典，1：市政设施，2：房建项目，3：其它）")
    @TableField("PROJECT_TYPE_")
    private Integer projectType;

    @ApiModelProperty(value = "工程属性（使用字典，1：道路，2：安置房，3：厂房，4：仓库，5：公租房，6：广场，7：土石方:8：围网:9：研发楼:10：停车场:11：消防站:12：研发，13：其它）")
    @TableField("PROJECT_NATURE_")
    private Integer projectNature;

    @ApiModelProperty(value = "项目负责人")
    @TableField("PROJECT_MANAGER_")
    private String projectManager;

    @ApiModelProperty(value = "项目负责人联系电话")
    @TableField("PROJECT_MANAGER_PHONE_")
    private String projectManagerPhone;

    @ApiModelProperty(value = "项目地址")
    @TableField("PROJECT_ADDRESS_")
    private String projectAddress;

    @ApiModelProperty(value = "项目规模及内容")
    @TableField("PROJECT_CONTENT_")
    private String projectContent;

    @ApiModelProperty(value = "采购方式（使用字典，1：平台招标，2：企业招标，3：企业线下定价）")
    @TableField("PROCUREMENT_METHOD_")
    private String procurementMethod;

    @ApiModelProperty(value = "招标方式（使用字典，1：招标采购:2：邀请招标采购:3：竞争性谈判:4：竞价采购:5：询价采购:6：单一来源采购:7：多源采购）")
    @TableField("APPLICATION_METHOD_")
    private String applicationMethod;

    @ApiModelProperty(value = "是否分包（0：否，1：是）")
    @TableField("HAS_SUBPACKAGE_")
    private String hasSubpackage;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private String hasQualification;

    @ApiModelProperty(value = "开工时间")
    @TableField("COMMENCEMENT_TIME_")
    private LocalDate commencementTime;

    @ApiModelProperty(value = "完工时间")
    @TableField("COMPLETION_TIME_")
    private LocalDate completionTime;

    @ApiModelProperty(value = "竣工验收时间")
    @TableField("COMPLETION_ACCEPTANCE_TIME_")
    private LocalDate completionAcceptanceTime;

    @ApiModelProperty(value = "质保期限（年）")
    @TableField("WARRANTY_EXPIRATION_TIME_")
    private BigDecimal warrantyExpirationTime;

    @ApiModelProperty(value = "责任单位ID")
    @TableField("RESPONSIBLE_UNIT_ID_")
    private String responsibleUnitId;

    @ApiModelProperty(value = "责任单位")
    @TableField("RESPONSIBLE_UNIT_")
    private String responsibleUnit;

    @ApiModelProperty(value = "设计单位ID")
    @TableField("DESIGN_UNIT_ID_")
    private String designUnitId;

    @ApiModelProperty(value = "设计单位")
    @TableField("DESIGN_UNIT_")
    private String designUnit;

    @ApiModelProperty(value = "监理单位ID")
    @TableField("SUPERVISOR_UNIT_ID_")
    private String supervisorUnitId;

    @ApiModelProperty(value = "监理单位")
    @TableField("SUPERVISOR_UNIT_")
    private String supervisorUnit;

    @ApiModelProperty(value = "施工单位ID")
    @TableField("CONSTRUCT_UNIT_ID_")
    private String constructUnitId;

    @ApiModelProperty(value = "施工单位")
    @TableField("CONSTRUCT_UNIT_")
    private String constructUnit;

    @ApiModelProperty(value = "启用禁用，（使用字典，1：有效（默认值），0：无效）")
    @TableField("VALID_FLAG_")
    private Integer validFlag;

    @ApiModelProperty(value = "基础扩展")
    @TableField("EXTENDED_FIELD1_")
    private String extendedField1;

    @ApiModelProperty(value = "其他扩展")
    @TableField("EXTENDED_FIELD2_")
    private String extendedField2;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人部门ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @ApiModelProperty(value = "创建人部门名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人部门ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @ApiModelProperty(value = "更新人部门名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
    public String getUserAccount() {
        return userAccount;
    }

    public void setUserAccount(String userAccount) {
        this.userAccount = userAccount;
    }
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }
    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public LocalDateTime getApplicationDate() {
        return applicationDate;
    }

    public void setApplicationDate(LocalDateTime applicationDate) {
        this.applicationDate = applicationDate;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId;
    }
    public String getNoticeTitle() {
        return noticeTitle;
    }

    public void setNoticeTitle(String noticeTitle) {
        this.noticeTitle = noticeTitle;
    }
    public String getNoticeNumber() {
        return noticeNumber;
    }

    public void setNoticeNumber(String noticeNumber) {
        this.noticeNumber = noticeNumber;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getPurchasingApplicationId() {
        return purchasingApplicationId;
    }

    public void setPurchasingApplicationId(String purchasingApplicationId) {
        this.purchasingApplicationId = purchasingApplicationId;
    }
    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getProjectMoney() {
        return projectMoney;
    }

    public void setProjectMoney(BigDecimal projectMoney) {
        this.projectMoney = projectMoney;
    }
    public String getProjectModel() {
        return projectModel;
    }

    public void setProjectModel(String projectModel) {
        this.projectModel = projectModel;
    }
    public Integer getProjectType() {
        return projectType;
    }

    public void setProjectType(Integer projectType) {
        this.projectType = projectType;
    }
    public Integer getProjectNature() {
        return projectNature;
    }

    public void setProjectNature(Integer projectNature) {
        this.projectNature = projectNature;
    }
    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectManagerPhone() {
        return projectManagerPhone;
    }

    public void setProjectManagerPhone(String projectManagerPhone) {
        this.projectManagerPhone = projectManagerPhone;
    }
    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }
    public String getProjectContent() {
        return projectContent;
    }

    public void setProjectContent(String projectContent) {
        this.projectContent = projectContent;
    }
    public String getProcurementMethod() {
        return procurementMethod;
    }

    public void setProcurementMethod(String procurementMethod) {
        this.procurementMethod = procurementMethod;
    }
    public String getApplicationMethod() {
        return applicationMethod;
    }

    public void setApplicationMethod(String applicationMethod) {
        this.applicationMethod = applicationMethod;
    }
    public String getHasSubpackage() {
        return hasSubpackage;
    }

    public void setHasSubpackage(String hasSubpackage) {
        this.hasSubpackage = hasSubpackage;
    }
    public String getHasQualification() {
        return hasQualification;
    }

    public void setHasQualification(String hasQualification) {
        this.hasQualification = hasQualification;
    }
    public LocalDate getCommencementTime() {
        return commencementTime;
    }

    public void setCommencementTime(LocalDate commencementTime) {
        this.commencementTime = commencementTime;
    }
    public LocalDate getCompletionTime() {
        return completionTime;
    }

    public void setCompletionTime(LocalDate completionTime) {
        this.completionTime = completionTime;
    }
    public LocalDate getCompletionAcceptanceTime() {
        return completionAcceptanceTime;
    }

    public void setCompletionAcceptanceTime(LocalDate completionAcceptanceTime) {
        this.completionAcceptanceTime = completionAcceptanceTime;
    }
    public BigDecimal getWarrantyExpirationTime() {
        return warrantyExpirationTime;
    }

    public void setWarrantyExpirationTime(BigDecimal warrantyExpirationTime) {
        this.warrantyExpirationTime = warrantyExpirationTime;
    }
    public String getResponsibleUnitId() {
        return responsibleUnitId;
    }

    public void setResponsibleUnitId(String responsibleUnitId) {
        this.responsibleUnitId = responsibleUnitId;
    }
    public String getResponsibleUnit() {
        return responsibleUnit;
    }

    public void setResponsibleUnit(String responsibleUnit) {
        this.responsibleUnit = responsibleUnit;
    }
    public String getDesignUnitId() {
        return designUnitId;
    }

    public void setDesignUnitId(String designUnitId) {
        this.designUnitId = designUnitId;
    }
    public String getDesignUnit() {
        return designUnit;
    }

    public void setDesignUnit(String designUnit) {
        this.designUnit = designUnit;
    }
    public String getSupervisorUnitId() {
        return supervisorUnitId;
    }

    public void setSupervisorUnitId(String supervisorUnitId) {
        this.supervisorUnitId = supervisorUnitId;
    }
    public String getSupervisorUnit() {
        return supervisorUnit;
    }

    public void setSupervisorUnit(String supervisorUnit) {
        this.supervisorUnit = supervisorUnit;
    }
    public String getConstructUnitId() {
        return constructUnitId;
    }

    public void setConstructUnitId(String constructUnitId) {
        this.constructUnitId = constructUnitId;
    }
    public String getConstructUnit() {
        return constructUnit;
    }

    public void setConstructUnit(String constructUnit) {
        this.constructUnit = constructUnit;
    }
    public Integer getValidFlag() {
        return validFlag;
    }

    public void setValidFlag(Integer validFlag) {
        this.validFlag = validFlag;
    }
    public String getExtendedField1() {
        return extendedField1;
    }

    public void setExtendedField1(String extendedField1) {
        this.extendedField1 = extendedField1;
    }
    public String getExtendedField2() {
        return extendedField2;
    }

    public void setExtendedField2(String extendedField2) {
        this.extendedField2 = extendedField2;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public String getCreateDeptId() {
        return createDeptId;
    }

    public void setCreateDeptId(String createDeptId) {
        this.createDeptId = createDeptId;
    }
    public String getCreateDeptName() {
        return createDeptName;
    }

    public void setCreateDeptName(String createDeptName) {
        this.createDeptName = createDeptName;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
    public String getUpdateDeptId() {
        return updateDeptId;
    }

    public void setUpdateDeptId(String updateDeptId) {
        this.updateDeptId = updateDeptId;
    }
    public String getUpdateDeptName() {
        return updateDeptName;
    }

    public void setUpdateDeptName(String updateDeptName) {
        this.updateDeptName = updateDeptName;
    }
    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }
    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizUserApplicationProjectDetails{" +
            "id=" + id +
            ", userId=" + userId +
            ", userAccount=" + userAccount +
            ", userName=" + userName +
            ", companyCode=" + companyCode +
            ", userPhone=" + userPhone +
            ", companyId=" + companyId +
            ", applicationDate=" + applicationDate +
            ", companyName=" + companyName +
            ", noticeId=" + noticeId +
            ", noticeTitle=" + noticeTitle +
            ", noticeNumber=" + noticeNumber +
            ", status=" + status +
            ", purchasingApplicationId=" + purchasingApplicationId +
            ", projectId=" + projectId +
            ", projectCode=" + projectCode +
            ", projectName=" + projectName +
            ", projectMoney=" + projectMoney +
            ", projectModel=" + projectModel +
            ", projectType=" + projectType +
            ", projectNature=" + projectNature +
            ", projectManager=" + projectManager +
            ", projectManagerPhone=" + projectManagerPhone +
            ", projectAddress=" + projectAddress +
            ", projectContent=" + projectContent +
            ", procurementMethod=" + procurementMethod +
            ", applicationMethod=" + applicationMethod +
            ", hasSubpackage=" + hasSubpackage +
            ", hasQualification=" + hasQualification +
            ", commencementTime=" + commencementTime +
            ", completionTime=" + completionTime +
            ", completionAcceptanceTime=" + completionAcceptanceTime +
            ", warrantyExpirationTime=" + warrantyExpirationTime +
            ", responsibleUnitId=" + responsibleUnitId +
            ", responsibleUnit=" + responsibleUnit +
            ", designUnitId=" + designUnitId +
            ", designUnit=" + designUnit +
            ", supervisorUnitId=" + supervisorUnitId +
            ", supervisorUnit=" + supervisorUnit +
            ", constructUnitId=" + constructUnitId +
            ", constructUnit=" + constructUnit +
            ", validFlag=" + validFlag +
            ", extendedField1=" + extendedField1 +
            ", extendedField2=" + extendedField2 +
            ", remarks=" + remarks +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createDeptId=" + createDeptId +
            ", createDeptName=" + createDeptName +
            ", createOrgId=" + createOrgId +
            ", createOrgName=" + createOrgName +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateDeptId=" + updateDeptId +
            ", updateDeptName=" + updateDeptName +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
