package com.artfess.cgpt.order.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.order.manager.BizRegistrationOrderDetailsManager;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.dao.BizRegistrationOrderDao;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.order.vo.OrderDetailsVo;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 订单表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@Service
public class BizRegistrationOrderManagerImpl extends BaseManagerImpl<BizRegistrationOrderDao, BizRegistrationOrder> implements BizRegistrationOrderManager {

    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private BizRegistrationOrderDetailsManager registrationOrderDetailsManager;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private OrgManager orgManager;

    @Value("${zfpt.getAccountUrl}")
    private String getAccountUrl;

    @Override
    public BizRegistrationOrder getByIdNoTenant(String id) {
        BizRegistrationOrder result = baseMapper.getByIdNoTenant(id);
        return result;
    }

    @Override
    public PageList<BizRegistrationOrder> queryAllByPage(QueryFilter<BizRegistrationOrder> queryFilter) {
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);
        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizRegistrationOrder> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }


    @Override
    public BizRegistrationOrder getDetailById(String id) {
        BizRegistrationOrder order = this.getById(id);
        List<BizRegistrationOrderDetails> details = registrationOrderDetailsManager.getListByOrderId(id);
        order.setDetailsList(details);
        return order;
    }


    @Override
    public void saveVo(BizRegistrationOrder entity) {


        this.saveOrUpdate(entity);
        List<BizRegistrationOrderDetails> detailsList = entity.getDetailsList();

        for (BizRegistrationOrderDetails details : detailsList) {
            details.setRegistrationOrderId(entity.getId());
            details.setRegistrationOrderNumber(entity.getOrderNumber());
        }
        registrationOrderDetailsManager.saveOrUpdateBatch(detailsList);

    }

    @Override
    public JSONObject getCurrentAccount() {
        String orgId = baseContext.getCurrentOrgId();
        if(""==orgId) {
            return null;
        }
        //获取当前公司编号
        ObjectNode org = ucFeignService.getOrgByIdOrCode(orgId);
        JSONObject param = new JSONObject();
        param.set("bankCompanyCode",org.get("code").textValue());
        JSONObject jsonObject = foreignCallService.callInterfaceResponse(getAccountUrl, param, 2);
        return jsonObject;
    }

    @Override
    public void payByBalance(BizRegistrationOrder trans) {
        List<String> partIds = Arrays.asList(trans.getParticipationId().split(","));
        List<UserParticipation> userParts = userParticipationManager.listByIds(partIds);
        if(BeanUtils.isEmpty(userParts) || userParts.size()<=0){
            throw new BaseException("请选择记录");
        }
        Map<Integer, List<UserParticipation>> collect = userParts.stream().collect(Collectors.groupingBy(UserParticipation::getType));
        //1.保证金，2.标书费
        collect.forEach((type,data)->{
            feePay(type,data,partIds,trans);
        });

    }

    @Transactional
    public void feePay(Integer type,List<UserParticipation> data,List<String> partIds,BizRegistrationOrder trans) {
        if(type==1){
            //如果是保证金，查询项目标书费是否支付
            for(UserParticipation temp : data){
                if(BeanUtils.isNotEmpty(temp.getDocumentFeeId())){
                    if(!partIds.contains(temp.getDocumentFeeId())){
                        UserParticipation docFeeData = userParticipationManager.getById(temp.getDocumentFeeId());
                        if(BeanUtils.isNotEmpty(docFeeData) && docFeeData.getPrice().compareTo(BigDecimal.ZERO)>0
                                && docFeeData.getStatus()!=1){
                            throw new BaseException("请先支付项目标书费："+docFeeData.getNoticeTitle());
                        }
                    }
                }
            }
            trans.setPayType(2);
        }else if(type==2){
            //标书费
            trans.setPayType(5);
        }

        BigDecimal amount = BigDecimal.ZERO;
        for(UserParticipation temp : data){
            amount = amount.add(temp.getPrice());
        }

        String noticeName = "";
        if(trans.getNoticeType().equals(1)){
            MatApproval notice = matApprovalManager.getById(trans.getNoticeId());
            noticeName = notice.getNoticeTitle();
        }else {
            ProjectApproval notice = projectApprovalManager.getById(trans.getNoticeId());
            noticeName = notice.getNoticeTitle();
        }

        String orderNumber = BizUtils.getNextSerialNumber(systemConfigFeignService, "zfjl_ddh");
        trans.setOrderNumber(orderNumber);
        trans.setPayStatus(3);
        IUser user = ContextUtil.getCurrentUser();
        trans.setUserId(user.getUserId());
        trans.setUserAccount(user.getAccount());
        trans.setUserName(user.getFullname());
        if(BeanUtils.isNotEmpty(user.getMobile())){
            trans.setUserPhone(user.getMobile());
        }

        IGroup org = ContextUtil.getCurrentGroup();
        trans.setPayUnitId(org.getGroupId());
        trans.setPayUnitCode(org.getGroupCode());
        trans.setPayUnitName(org.getName());
        trans.setPayTime(LocalDateTime.now());
        trans.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));

        Org colOrg = orgManager.getByCode("00001513");
        if(BeanUtils.isEmpty(colOrg)){
            throw new BaseException("未找到编号为【00001513】企业信息，请联系相关人员注册");
        }
        trans.setCollectUnitId(colOrg.getId());
        trans.setCollectUnitCode(colOrg.getCode());
        trans.setCollectUnitName(colOrg.getName());
        trans.setCollectTime(trans.getPayTime());
        trans.setCollectTimer(trans.getPayTimer());

        //保证金：设置备注为缴纳保证金
        if(trans.getPayType().equals(2)) {
            trans.setPayDescribe("缴纳保证金");
        }else if(trans.getPayType().equals(5)){
            trans.setPayDescribe("缴纳标书费");
        }

        trans.setPayAmount(amount);
        super.save(trans);

        List<BizRegistrationOrderDetails> detailedList = new ArrayList<>();
        List<OrderDetailsVo> orderDetailsList = new ArrayList<>();
        ForeignResponseVo res = null;

        if(trans.getPayType().equals(2) || trans.getPayType().equals(5)){
            TransVo transVo = new TransVo();
            try {
                BeanUtils.copyNotNullProperties(transVo,trans);
            } catch (ReflectiveOperationException e) {
                e.printStackTrace();
                throw new BaseException(e.getMessage());
            }
            transVo.setStatementsCode(trans.getOrderNumber());
            transVo.setDepositPaymentStatus(trans.getPayStatus());

            for(UserParticipation temp : data){
                BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
                detail.setRegistrationOrderId(trans.getId());
                detail.setRegistrationOrderNumber(trans.getOrderNumber());
                detail.setUserId(trans.getUserId());
                detail.setUserName(trans.getUserName());
                detail.setUserAccount(trans.getUserAccount());
                if(BeanUtils.isNotEmpty(trans.getUserPhone())) {
                    detail.setUserPhone(trans.getUserPhone());
                }
                detail.setCompanyId(trans.getPayUnitId());
                detail.setCompanyCode(trans.getPayUnitCode());
                detail.setCompanyName(trans.getPayUnitName());
                detail.setNoticeId(temp.getNoticeId());
                detail.setNoticeType(temp.getNoticeType());
                detail.setNoticeTitle(temp.getNoticeTitle());
                detail.setPayName(temp.getNoticeTitle());
                detail.setRechargeNumber(BigDecimal.ONE);
                detail.setRechargePrice(temp.getPrice());
                detail.setSalesCompanyId(trans.getCollectUnitId());
                detail.setSalesCompanyCode(trans.getCollectUnitCode());
                detail.setSalesCompanyName(trans.getCollectUnitName());
                detailedList.add(detail);
                OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
                try {
                    BeanUtils.copyNotNullProperties(orderDetailsVo,detail);
                } catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    System.out.println("订单明细转换错误："+e.getMessage());
                    throw new BaseException("订单明细转换错误："+e.getMessage());
                }
                if(temp.getType()==2){
                    //标书费
                    orderDetailsVo.setPayType(5);
                }else {
                    //保证金
                    orderDetailsVo.setPayType(2);
                }
                orderDetailsList.add(orderDetailsVo);
            }

            transVo.setOrderDetails(orderDetailsList);
            if(trans.getPayType().equals(2)) {
                //保证金
                res = foreignCallService.callPay(transVo, 1);
            }else {
                //标书费
                res = foreignCallService.callPay(transVo, 2);
            }

        }

        if(BeanUtil.isEmpty(res)) {
            throw new BaseException("调用[支付平台]支付失败");
        }
        if(!res.getCode().equals("0")) {
            throw new BaseException("调用[支付平台]支付失败:"+ res.getMsg());
        }

        if(detailedList.size()>0){
            registrationOrderDetailsManager.saveBatch(detailedList);
        }

        List<String> updateDataIds = data.stream().map(s -> s.getId()).collect(Collectors.toList());

        if(type==2){
            //标书费
            //查询保证金为已支付的，更新状态为已参与
            LambdaUpdateWrapper<UserParticipation> bondUW = new LambdaUpdateWrapper<>();
            bondUW.set(UserParticipation::getStatus,1)
                    .in(UserParticipation::getDocumentFeeId,updateDataIds)
                    .eq(UserParticipation::getType,1)
                    .eq(UserParticipation::getStatus,4)
                    .eq(UserParticipation::getIsDele,"0");
            userParticipationManager.update(bondUW);
        }

        //保证金或标书费，修改参与表 状态为已报名、支付状态为已支付
        LambdaUpdateWrapper<UserParticipation> userParticipationUW = new LambdaUpdateWrapper<>();
        userParticipationUW.set(UserParticipation::getStatus,1)
                .set(UserParticipation::getRegistrationOrderId,trans.getId())
                .set(UserParticipation::getRegistrationOrderNumber,trans.getOrderNumber())
                .in(UserParticipation::getId,updateDataIds)
//                    .eq(UserParticipation::getType,type)
                .eq(UserParticipation::getIsDele,"0");
        userParticipationManager.update(userParticipationUW);

    }

    @Override
    @Transactional
    public void refundBond(UserParticipation userPart) {
        //1.查询保证金支付记录
        BizRegistrationOrder regisOrder = super.getById(userPart.getRegistrationOrderId());

        //2.生成退还保证金记录
        BizRegistrationOrder refundRegisOrder = new BizRegistrationOrder();
        refundRegisOrder.setParticipationId(userPart.getId());
        String orderNumber = BizUtils.getNextSerialNumber(systemConfigFeignService, "zfjl_ddh");
        refundRegisOrder.setOrderNumber(orderNumber);
        refundRegisOrder.setPayStatus(3);
        refundRegisOrder.setRefundStatus(1);
        refundRegisOrder.setNoticeId(userPart.getNoticeId());
        refundRegisOrder.setNoticeType(1);
        if(BeanUtils.isNotEmpty(regisOrder.getUserId())){
            refundRegisOrder.setUserId(regisOrder.getUserId());
        }
        if(BeanUtils.isNotEmpty(regisOrder.getUserAccount())){
            refundRegisOrder.setUserAccount(regisOrder.getUserAccount());
        }
        if(BeanUtils.isNotEmpty(regisOrder.getUserName())){
            refundRegisOrder.setUserName(regisOrder.getUserName());
        }
        if(BeanUtils.isNotEmpty(regisOrder.getUserPhone())) {
            refundRegisOrder.setUserPhone(regisOrder.getUserPhone());
        }
        refundRegisOrder.setPayType(6);
        Org payOrg = orgManager.getByCode("00001513");
        if(BeanUtils.isEmpty(payOrg)){
            throw new BaseException("未找到编号为【00001513】企业信息，请联系相关人员注册");
        }
        refundRegisOrder.setPayUnitId(regisOrder.getCollectUnitId());
        refundRegisOrder.setPayUnitCode(regisOrder.getCollectUnitCode());
        refundRegisOrder.setPayUnitName(regisOrder.getCollectUnitName());
        refundRegisOrder.setPayAccount(regisOrder.getCollectAccount());
        refundRegisOrder.setPayAccountBank(regisOrder.getCollectAccountBank());
        refundRegisOrder.setPayTime(LocalDateTime.now());
        refundRegisOrder.setPayTimer(LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        refundRegisOrder.setPayAmount(regisOrder.getPayAmount());
        refundRegisOrder.setCollectUnitId(regisOrder.getPayUnitId());
        refundRegisOrder.setCollectUnitCode(regisOrder.getPayUnitCode());
        refundRegisOrder.setCollectUnitName(regisOrder.getPayUnitName());
        refundRegisOrder.setCollectAccount(regisOrder.getPayAccount());
        refundRegisOrder.setCollectAccountBank(regisOrder.getPayAccountBank());
        refundRegisOrder.setCollectTime(regisOrder.getPayTime());
        refundRegisOrder.setCollectTimer(regisOrder.getPayTimer());
        refundRegisOrder.setPayDescribe("退还保证金");
        super.save(refundRegisOrder);
        List<BizRegistrationOrderDetails> detailedList = new ArrayList<>();
        ForeignResponseVo res = null;

        //保证金
        TransVo transVo = new TransVo();
        try {
            BeanUtils.copyNotNullProperties(transVo,refundRegisOrder);
        } catch (ReflectiveOperationException e) {
            e.printStackTrace();
            throw new BaseException(e.getMessage());
        }
        transVo.setStatementsCode(refundRegisOrder.getOrderNumber());
        transVo.setDepositPaymentStatus(refundRegisOrder.getPayStatus());

        BizRegistrationOrderDetails detail = new BizRegistrationOrderDetails();
        detail.setRegistrationOrderId(refundRegisOrder.getId());
        detail.setRegistrationOrderNumber(refundRegisOrder.getOrderNumber());

        detail.setUserId(refundRegisOrder.getUserId());
        detail.setUserName(refundRegisOrder.getUserName());
        detail.setUserAccount(refundRegisOrder.getUserAccount());
        if(BeanUtils.isNotEmpty(refundRegisOrder.getUserPhone())) {
            detail.setUserPhone(refundRegisOrder.getUserPhone());
        }
        detail.setCompanyId(refundRegisOrder.getPayUnitId());
        detail.setCompanyCode(refundRegisOrder.getPayUnitCode());
        detail.setCompanyName(refundRegisOrder.getPayUnitName());
        detail.setNoticeId(refundRegisOrder.getNoticeId());
        detail.setNoticeType(refundRegisOrder.getNoticeType());
        detail.setNoticeTitle(userPart.getNoticeTitle());
        detail.setPayName(userPart.getNoticeTitle());
        detail.setRechargeNumber(BigDecimal.ONE);
        detail.setRechargePrice(refundRegisOrder.getPayAmount());
        detail.setSalesCompanyId(refundRegisOrder.getCollectUnitId());
        detail.setSalesCompanyCode(refundRegisOrder.getCollectUnitCode());
        detail.setSalesCompanyName(refundRegisOrder.getCollectUnitName());
        detailedList.add(detail);

        List<OrderDetailsVo> orderDetailsList = new ArrayList<>();
        OrderDetailsVo orderDetailsVo = new OrderDetailsVo();
        try {
            BeanUtils.copyNotNullProperties(orderDetailsVo,detail);
        } catch (ReflectiveOperationException e) {
            e.printStackTrace();
            System.out.println("订单明细转换错误："+e.getMessage());
            throw new BaseException("订单明细转换错误："+e.getMessage());
        }
        orderDetailsVo.setPayType(6);
        orderDetailsList.add(orderDetailsVo);
        transVo.setOrderDetails(orderDetailsList);

        //3.调用支付平台内部支付接口
        res = foreignCallService.callPay(transVo, 1);

        if(BeanUtil.isEmpty(res)) {
            throw new BaseException("调用[支付平台]支付失败");
        }
        if(!res.getCode().equals("0")) {
            throw new BaseException("调用[支付平台]支付失败:"+ res.getMsg());
        }

        if(detailedList.size()>0){
            registrationOrderDetailsManager.saveBatch(detailedList);
        }

        regisOrder.setRefundStatus(3);
        regisOrder.setRefundOrderId(refundRegisOrder.getId());
        super.updateById(regisOrder);
        //设置退款id
        userPart.setRefundRegistrationOrderId(refundRegisOrder.getId());
        userPart.setRefundRegistrationOrderNumber(refundRegisOrder.getOrderNumber());
        userParticipationManager.updateById(userPart);
    }

}
