package com.artfess.cgpt.material.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 物料分级管理应用企业表（查询时需要结合物料分级管理表中创建企业进行联合判断，默认创建企业就不添加到表格中来）
 *
 * @company artfess.com
 * @author baseli
 * @since 2024-08-15
 */
@ApiModel(value="BizMaterialHierarchicalManagementRange对象", description="物料分级管理应用企业表（查询时需要结合物料分级管理表中创建企业进行联合判断，默认创建企业就不添加到表格中来）")
@Data
@TableName("biz_material_hierarchical_management_range")
public class MaterialHierarchicalManagementRange extends BizModel<MaterialHierarchicalManagementRange> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "物料分级管理ID（关联物料分级管理表ID）")
    @TableField("MATERIAL_HIERARCHICAL_ID_")
    private String materialHierarchicalId;

    @ApiModelProperty(value = "企业ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "企业编码")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "排序号（自动生成）")
    @TableField("SN_")
    private Long sn;

    @ApiModelProperty(value = "是否删除，(0：未删除,1：已删除)")
    @TableField("IS_DELE_")
    private String isDele;

}
