package com.artfess.cgpt.material.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.contract.model.ContractItem;
import com.artfess.cgpt.material.dao.ProductDao;
import com.artfess.cgpt.material.manager.ProductDetailManager;
import com.artfess.cgpt.material.manager.ProductManager;
import com.artfess.cgpt.material.model.Product;
import com.artfess.cgpt.material.model.ProductDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/12 15:08
 */
@Service
public class ProductManagerImpl extends BaseManagerImpl<ProductDao, Product> implements ProductManager {

    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ProductDetailManager productDetailManager;

    @Override
    public PageList<Product> queryAllByPage(QueryFilter<Product> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<Product> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(Product entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<ProductDetail> detailList = entity.getDetailList();

        if(BeanUtils.isNotEmpty(entity.getId())){
            accessoryService.removeBySourceId(entity.getId());
            LambdaQueryWrapper<ProductDetail> detailQW = new LambdaQueryWrapper<>();
            detailQW.eq(ProductDetail::getProductId,entity.getId());
            productDetailManager.remove(detailQW);
        }

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
            detailList.forEach(s->s.setProductId(entity.getId()));
            productDetailManager.saveBatch(detailList);
        }

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

    }

    @Override
    @Transactional
    public void updateStatusByIds(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper<Product> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(Product::getStatus,status)
                .in(Product::getId,idList).eq(Product::getIsDele,"0");
        super.update(updateWrapper);
    }

    @Override
    @Transactional
    public void removeData(List<String> ids) {
        super.removeByIds(ids);
        LambdaQueryWrapper<ProductDetail> contractItemQW = new LambdaQueryWrapper<>();
        contractItemQW.in(ProductDetail::getProductId,ids);
        productDetailManager.remove(contractItemQW);
        accessoryService.removeBySourceIds(ids);
    }

    @Override
    public Product getDataById(String id) {
        Product result = super.getById(id);
        LambdaQueryWrapper<ProductDetail> contractItemQW = new LambdaQueryWrapper<>();
        contractItemQW.eq(ProductDetail::getProductId,id);
        result.setDetailList(productDetailManager.list(contractItemQW));
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));
        return result;
    }

}
