package com.artfess.cgpt.material.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.dao.BizMaterialDao;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.material.vo.MatCategoryVo;
import com.artfess.cgpt.material.vo.MaterialVo;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 *  服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-22
 */
@Service
public class BizMaterialManagerImpl extends BaseManagerImpl<BizMaterialDao, BizMaterial> implements BizMaterialManager {

    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private PlatMaterialManager platMaterialManager;
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private EnterpriseManager enterpriseManager;

    @Override
    public PageList<BizMaterial> queryAllByPage(QueryFilter<BizMaterial> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<BizMaterial> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }

    @Override
    public void exportExcelData(QueryFilter<BizMaterial> queryFilter, HttpServletResponse response) throws IOException {
//        queryFilter.setPageBean(new PageBean(0, -1, false));
        BizUtils.addFilterByHisOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_CODE_",enterpriseManager);
        PageList<BizMaterial> bizMaterialPageList = queryAllByPage(queryFilter);
        List<BizMaterial> data=bizMaterialPageList.getRows();

        String fileName = "企业物料-导出数据";

        if (null == data || data.size() == 0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置s
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, BizMaterial.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    @Transactional
    public void updateMatCategory(List<String> ids, String categoryCode) {
        LambdaUpdateWrapper<BizMaterial> materialUW = new LambdaUpdateWrapper<>();
        materialUW.set(BizMaterial::getMatCategory,categoryCode)
                .in(BizMaterial::getId,ids)
                .eq(BizMaterial::getMatStatus,1)
                .eq(BizMaterial::getIsDele,"0");
        super.update(materialUW);
    }

    @Override
    @Transactional
    public void updateMatStatus(List<String> ids, String status) {
        List<BizMaterial> materials = super.listByIds(ids);
        List<String> platCodes = materials.stream().map(s -> s.getMatPlatcode()).collect(Collectors.toList());

        //启用状态（0：禁用，1：启用）
        if(status.equals("0")){
            //如果是禁用
            //1.查询采购申请明细是否存在该物料的数据
            QueryWrapper<PurchasingApplicationDetails> applicationDetailQW = new QueryWrapper<>();
            applicationDetailQW.select("DISTINCT MAT_PLATCODE_")
                    .lambda().in(PurchasingApplicationDetails::getMatId,ids);
            List<Object> objList = applicationDetailsManager.listObjs(applicationDetailQW);

            //如果存在，不能禁用
            if(BeanUtils.isNotEmpty(objList) && objList.size()>0){
                List<String> matPlatCodes = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("平台物料编号【"+String.join(",",matPlatCodes)+"】已有关联数据，无法禁用");
            }
        }else {
            //如果是启用
            //查询平台物料是否禁用
            QueryWrapper<PlatMaterial> platMaterialQW = new QueryWrapper<>();
            platMaterialQW.select("DISTINCT MAT_PLATCODE_")
                    .lambda().in(PlatMaterial::getMatPlatcode,platCodes)
                    .eq(PlatMaterial::getMatStatus,0)
                    .eq(PlatMaterial::getIsDele,"0");
            List<Object> objList = platMaterialManager.listObjs(platMaterialQW);
            //如果已禁用，不能启用
            if(BeanUtils.isNotEmpty(objList) && objList.size()>0){
                List<String> tempMatPlatCodes = objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("平台物料【"+String.join(",",tempMatPlatCodes)+"】已禁用，无法启用");
            }
        }

        //2.修改启用状态
        LambdaUpdateWrapper<BizMaterial> materialUW = new LambdaUpdateWrapper<>();
        materialUW.set(BizMaterial::getMatStatus,status)
                .in(BizMaterial::getId,ids)
                .eq(BizMaterial::getIsDele,"0");
        super.update(materialUW);
    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(JSONObject param) {
        String code = "0";
        String message = "操作成功";
        String errDetail = "";
        try {
            List<MaterialVo> data = JSONUtil.toList(param.getJSONArray("data"), MaterialVo.class);
            for (MaterialVo temp : data) {
                //根据物料分类判断是否集采
                List<String> platCodes = Arrays.asList("01,02,03,04,07".split(","));
                if(platCodes.contains(temp.getMatCategory().substring(0,2))){
                    temp.setMatIfPlat(1);
                }else {
                    temp.setMatIfPlat(0);
                }
                
                BizMaterial material = new BizMaterial();
                BeanUtils.copyNotNullProperties(material,temp);
                material.setMatTransferTime(LocalDateTime.now());
                if(BeanUtils.isEmpty(material.getMatTaxrate())){
                    material.setMatTaxrate(13);
                }
                material.setAuditStatus("1");

                PlatMaterial platMaterial = new PlatMaterial();
                BeanUtils.copyNotNullProperties(platMaterial,material);

                //根据平台编号查询平台物料是否存在
                LambdaQueryWrapper<PlatMaterial> platMaterialQW = new LambdaQueryWrapper<>();
                platMaterialQW.eq(PlatMaterial::getMatPlatcode,material.getMatPlatcode())
                        .eq(PlatMaterial::getIsDele,"0");
                platMaterialManager.saveOrUpdate(platMaterial,platMaterialQW);

                if(BeanUtils.isNotEmpty(temp.getMatCompany()) && null!=temp.getMatCompany()){
                    material.setMatCompanyCode(temp.getMatCompany());
                    LambdaQueryWrapper<BizMaterial> qw = new LambdaQueryWrapper<>();
                    qw.eq(BizMaterial::getMatPlatcode,material.getMatPlatcode())
                            .eq(BizMaterial::getMatCompanyCode,material.getMatCompanyCode())
                            .eq(BizMaterial::getIsDele,"0");
                    super.saveOrUpdate(material,qw);
                }
            }
        }catch (Exception e){
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "操作失败:"+errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }

        return new Response<>(code, message, errDetail);
    }

}
