package com.artfess.cgpt.material.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.PlatMaterial;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/25 18:32
 */
public interface PlatMaterialManager extends BaseManager<PlatMaterial> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<PlatMaterial> queryAllByPage(QueryFilter<PlatMaterial> queryFilter);

    /**
     * 根据id集合修改物料状态
     * @param ids id集合
     * @param status 物料状态
     */
    void updateMatStatus(List<String> ids, String status);

    /**
     * 根据id集合修改物料分类
     * @param ids id集合
     * @param categoryCode 物料分类编号
     */
    void updateMatCategory(List<String> ids, String categoryCode);

    /**
     * 导出excel
     * @param queryFilter
     * @param response
     * @throws IOException
     */
    void exportExcelData(QueryFilter<PlatMaterial> queryFilter, HttpServletResponse response) throws IOException;

}
