package com.artfess.cgpt.material.manager;

import cn.hutool.json.JSONObject;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.base.manager.BaseManager;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 *  服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-22
 */
public interface BizMaterialManager extends BaseManager<BizMaterial> {

    PageList<BizMaterial> queryAllByPage(QueryFilter<BizMaterial> queryFilter);

    void exportExcelData(QueryFilter<BizMaterial> queryFilter, HttpServletResponse response) throws IOException;

    /**
     * 根据id集合修改物料分类
     * @param ids id集合
     * @param categoryCode 物料分类编号
     */
    void updateMatCategory(List<String> ids, String categoryCode);

    /**
     * 根据id集合修改物料状态
     * @param ids id集合
     * @param status 物料状态
     */
    void updateMatStatus(List<String> ids, String status);

    /**
     * 保存或更新数据（api）
     * @param param
     */
    Response saveOrUpdateByApi(JSONObject param);

}
