package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.manager.ProductDetailManager;
import com.artfess.cgpt.material.model.Product;
import com.artfess.cgpt.material.model.ProductDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:产品物料明细表
 * @Author: Rong Tao
 * @Date: 2024/8/12 15:26
 */
@RestController
@RequestMapping("/productDetail/v1/")
@Api(tags="产品物料明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProductDetailController extends BaseController<ProductDetailManager, ProductDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<ProductDetail>> queryByPage(@RequestBody QueryFilter<ProductDetail> queryFilter){
        PageList<ProductDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
