package com.artfess.cgpt.material.controller;


import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.material.model.MaterialHierarchicalManagementRange;
import com.artfess.cgpt.material.manager.MaterialHierarchicalManagementRangeManager;

import java.util.Arrays;
import java.util.List;

/**
 * 物料分级管理应用企业表（查询时需要结合物料分级管理表中创建企业进行联合判断，默认创建企业就不添加到表格中来） 前端控制器
 *
 * @company artfess.com
 * @author baseli
 * @since 2024-08-15
 */
@RestController
@RequestMapping("/material/bizMaterialHierarchicalManagementRange/v1/")
public class MaterialHierarchicalManagementRangeController extends BaseController<MaterialHierarchicalManagementRangeManager, MaterialHierarchicalManagementRange> {

    @PostMapping("/")
    @ApiOperation("添加数据的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="数据信息") @RequestBody MaterialHierarchicalManagementRange t) {
        boolean result = baseService.save(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("/batch")
    @ApiOperation("批量添加数据的接口")
    public CommonResult<String> createBatch(@ApiParam(name="model", value="数据信息") @RequestBody List<MaterialHierarchicalManagementRange> list) {
        boolean result = baseService.saveBatch(list);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<MaterialHierarchicalManagementRange> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<MaterialHierarchicalManagementRange> queryFilter) {
        return baseService.query(queryFilter);
    }

    @GetMapping("/{id}")
    @ApiOperation("根据id查询数据")
    public MaterialHierarchicalManagementRange getById(@ApiParam(name="id", value="数据id") @PathVariable String id) {
        return baseService.getById(id);
    }

    @PutMapping("/")
    @ApiOperation("更新数据")
    public CommonResult<String> updateById(@ApiParam(name="model", value="数据信息") @RequestBody MaterialHierarchicalManagementRange t) {
        boolean result = baseService.updateById(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新数据失败");
        }
        return new CommonResult<>();
    }

    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="数据id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除数据失败");
        }
        return new CommonResult<>();
    }

    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="数据集合") @RequestParam String...ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除数据失败");
        }
        return new CommonResult<>();
    }
}
