package com.artfess.cgpt.foreignApi.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.defxml.entity.SendTask;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.foreignApi.vo.WxTemplateVO;
import com.artfess.cgpt.utils.HttpUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserUniteManager;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserUnite;
import com.artfess.uc.params.user.UserVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @Description: 微信公众号接口类
 * @Author: Rong Tao
 * @Date: 2023/4/21 16:04
 */
@Service
public class WxPublicManager {

    @Value("${wxPublic.AppID}")
    private String appID;
    @Value("${wxPublic.AppSecret}")
    private String appSecret;
    @Value("${wxPublic.getTokenURL}")
    private String getTokenURL;
    @Value("${wxPublic.sendTemplateMessageURL}")
    private String sendTemplateMessageURL;
    @Value("${wxPublic.grantType}")
    private String grantType;
    @Value("${wxPublic.getTemplateURL}")
    private String getTemplateURL;
    @Value("${wxPublic.sendAllByTabURL}")
    private String sendAllByTabURL;
    @Value("${wxPublic.getUserURL}")
    private String getUserURL;
    @Value("${wxPublic.noticeTemplateId}")
    private String noticeTemplateId;
    @Value("${wxPublic.taskTemplateId}")
    private String taskTemplateId;
    @Value("${wxPublic.getOpenIdURL}")
    private String getOpenIdURL;
    //回调地址
    @Value("${wxPublic.backUrl}")
    private String backUrl;

    @Autowired
    RedisUtil redisUtil;

    @Autowired
    private UserManager userManager;

    @Autowired
    private UserUniteManager userUniteManager;

    @Autowired
    PasswordEncoder passwordEncoder;


    public String getWXToken(){
        //如果redis里存了微信的token就直接返回
        Object wxToken = redisUtil.get("wxToken");
        if(BeanUtils.isNotEmpty(wxToken)) return wxToken.toString();

        String url = getTokenURL;
        Map<String,Object> param = new HashMap<>();
        param.put("grant_type",grantType);
        param.put("appid",appID);
        param.put("secret",appSecret);
        String token = HttpUtil.get(url, param);
        String result = JSONObject.parseObject(token).getString("access_token");
        if(BeanUtils.isEmpty(result)){
            throw new BaseException("wx获取token失败："+token);
        }
        //将token存入redis
        redisUtil.set("wxToken", result, new Double(60*60*1.5).longValue());
        return result;
    }

    //2024-04-18 09:24
//    public String sendTemplateMessage(){
//        String url = sendTemplateMessageURL;
//        String replaceUrl = url.replace("ACCESS_TOKEN",getWXToken());
//        Map<String,Object> param = new HashMap<>();
//        Map<String,Object> data = new HashMap<>();
//        //接收用户的openid
//        param.put("touser","oNXct55AYRl1H1vTk6G-dQf2OQ5A");
//        param.put("template_id",templateId);
//        param.put("appid",appID);
//        param.put("url","http://recycling.scm-spwz.com/fvue/viewPlat/NoticeDetils?noticeTitle=%E9%87%8D%E5%BA%86%E6%B0%B4%E6%B3%B5%E5%8E%82%E6%9C%89%E9%99%90%E8%B4%A3%E4%BB%BB%E5%85%AC%E5%8F%B8%E9%97%B2%E7%BD%AE%E8%AE%BE%E5%A4%87%E5%85%AC%E5%BC%80%E5%A4%84%E7%BD%AE&id=1754342968816439296");
//        //标题
//        data.put("first",new WxTemplateVO("服务状态更新通知"));
//        //服务单号
//        data.put("keyword1",new WxTemplateVO("收到新的废旧物资处置公告"));
//        //服务主题-公告标题
//        data.put("keyword2",new WxTemplateVO("重庆水泵厂有限责任公司废旧物资公开处置"));
//        //服务状态
//        data.put("keyword3",new WxTemplateVO("废旧物资处置"));
//        //处理时间
//        data.put("keyword4",new WxTemplateVO("2024-02-05 15:23:01"));
////        data.put("remark",new WxTemplateVO(""));
//        param.put("data",data);
//        String json = HttpUtil.post(replaceUrl, param);
//        return json;
//    }


    /**
     * 发送立项公告模版消息
     * @param template 参数
     * @return
     */
    public String sendNoticeTemplateMessage(WxNoticeTemplate template){
        Map<String,Object> param = new HashMap<>();
        Map<String,Object> data = new HashMap<>();
        //接收用户的openid
        param.put("touser","oNXct55AYRl1H1vTk6G-dQf2OQ5A");
        param.put("template_id",noticeTemplateId);
        //标题
        data.put("first",new WxTemplateVO("服务状态更新通知"));
        //服务单号:公告名称
        data.put("keyword1",new WxTemplateVO(template.getKeyword1()));
        //服务主题:需求企业
        data.put("keyword2",new WxTemplateVO(template.getKeyword2()));
        //服务状态:招标类型+竞价
        data.put("keyword3",new WxTemplateVO(template.getKeyword3()+"竞价"));
        //处理时间:发布时间
        data.put("keyword4",new WxTemplateVO(template.getKeyword4()));
        if(BeanUtils.isNotEmpty(template.getUrl())) param.put("url",template.getUrl());
        //        data.put("remark",new WxTemplateVO(""));
        param.put("data",data);
        return sendTemplateMessage(param);
    }

    /**
     * 发送立项公告模版消息到所有人
     * @param template 参数
     * @return
     */
//    public void sendNoticeTemplateMessageToAll(WxNoticeTemplate template){
//        String accessToken = getWXToken();
//        List<String> openidList = new ArrayList<>();
//        Integer total = getOpenIdList(openidList, accessToken, "");
//        // 用户数量较多, 使用多线程发送
//        ExecutorService executor = Executors.newFixedThreadPool(35);
//        for (String openid : openidList) {
//            Map<String,Object> param = new HashMap<>();
//            Map<String,Object> data = new HashMap<>();
//            param.put("template_id",noticeTemplateId);
//            //标题
//            data.put("first",new WxTemplateVO("服务状态更新通知"));
//            //服务单号:公告名称
//            data.put("keyword1",new WxTemplateVO(template.getKeyword1()));
//            //服务主题:需求企业
//            data.put("keyword2",new WxTemplateVO(template.getKeyword2()));
//            //服务状态:招标类型+竞价
//            data.put("keyword3",new WxTemplateVO(template.getKeyword3()+"竞价"));
//            //处理时间:发布时间
//            data.put("keyword4",new WxTemplateVO(template.getKeyword4()));
//            if(BeanUtils.isNotEmpty(template.getUrl())) param.put("url",template.getUrl());
//            //        data.put("remark",new WxTemplateVO(""));
//            param.put("data",data);
//
//            executor.execute(new SendTask(accessToken,openid,param));
//        }
//    }

    /**
     * 发送待办模版消息
     * @param template 参数
     * @return
     */
//    public String sendTaskTemplateMessage(WxTaskTemplate template){
//        Map<String,Object> param = new HashMap<>();
//        Map<String,Object> data = new HashMap<>();
//        //接收用户的openid
//        param.put("touser","oNXct55AYRl1H1vTk6G-dQf2OQ5A");
//        param.put("template_id",taskTemplateId);
//        //标题
//        data.put("first",new WxTemplateVO(template.getFirst()));
//        //申请时间
//        data.put("keyword1",new WxTemplateVO(template.getKeyword1()));
//        //申请业务
//        data.put("keyword2",new WxTemplateVO(template.getKeyword2()));
//        //当前状态
//        data.put("keyword3",new WxTemplateVO(template.getKeyword3()));
//        if(BeanUtils.isNotEmpty(template.getUrl())) param.put("url",template.getUrl());
//        //        data.put("remark",new WxTemplateVO(""));
//        param.put("data",data);
//        return sendTemplateMessage(param);
//    }

    /**
     * 发送模版消息
     * @param param 参数
     * @return
     */
    public String sendTemplateMessage(Map<String,Object> param){
        String url = sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN",getWXToken());
        param.put("appid",appID);
        System.out.println("推送微信模版消息请求参数："+param);
        String json = HttpUtil.post(replaceUrl, param);
        return json;
    }

    public String sendTemplateMessage(String openId){
        String url = sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN",getWXToken());
        Map<String,Object> param = new HashMap<>();
        Map<String,Object> data = new HashMap<>();
        //接收用户的openid
        param.put("touser",openId);
        param.put("template_id",noticeTemplateId);
        param.put("appid",appID);
        param.put("url","https://www.baidu.com");
        //标题
        data.put("first",new WxTemplateVO("重庆水泵厂有限责任公司废旧物资公开处置"));
        //服务单号
        data.put("keyword1",new WxTemplateVO("202404150001"));
        //服务主题-公告标题
        data.put("keyword2",new WxTemplateVO("重庆水泵厂有限责任公司废旧物资公开处置"));
        //服务状态
        data.put("keyword3",new WxTemplateVO("废旧物资处置"));
        //处理时间
        data.put("keyword4",new WxTemplateVO("2024-04-16 16:26:12"));
//        data.put("remark",new WxTemplateVO(""));
        param.put("data",data);
        String json = HttpUtil.post(replaceUrl, param);
        return json;
    }

//    public void sendTemplateMessageToAll(WxNoticeTemplate wxTemplate){
//        String accessToken = getWXToken();
//
//        List<String> openidList = new ArrayList<>();
//        Integer total = getOpenIdList(openidList, accessToken, "");
//        // 用户数量较多, 使用多线程发送
//        if (total == openidList.size()) {
//            ExecutorService executor = Executors.newFixedThreadPool(35);
//            for (String openid : openidList) {
////                param.put("touser",openid);
////                sendTemplateMessage(accessToken,param);
//
//                Map<String,Object> param = new HashMap<>();
//                Map<String,Object> data = new HashMap<>();
//                param.put("template_id",noticeTemplateId);
//                param.put("appid",appID);
//                param.put("data",data);
//                executor.execute(new SendTask(accessToken,openid,param));
//            }
//        }
//
//
//    }

//    public void sendTemplateMessageToAll(){
//        String accessToken = getWXToken();
//        List<String> openidList = new ArrayList<>();
//        Integer total = getOpenIdList(openidList, accessToken, "");
//        // 用户数量较多, 使用多线程发送
//        if (total == openidList.size()) {
//            ExecutorService executor = Executors.newFixedThreadPool(35);
//            for (String openid : openidList) {
//                Map<String,Object> param = new HashMap<>();
//                Map<String,Object> data = new HashMap<>();
//                //接收用户的openid
//                param.put("template_id",noticeTemplateId);
//                param.put("appid",appID);
//                param.put("url","https://www.baidu.com");
//                //标题
//                data.put("first",new WxTemplateVO("重庆水泵厂有限责任公司废旧物资公开处置"));
//                //服务单号
//                data.put("keyword1",new WxTemplateVO("202404150001"));
//                //服务主题-公告标题
//                data.put("keyword2",new WxTemplateVO("重庆水泵厂有限责任公司废旧物资公开处置"));
//                //服务状态
//                data.put("keyword3",new WxTemplateVO("废旧物资处置"));
//                //处理时间
//                data.put("keyword4",new WxTemplateVO("2024-04-16 16:26:12"));
////        data.put("remark",new WxTemplateVO(""));
//                param.put("data",data);
//                executor.execute(new SendTask(accessToken,openid,param));
//            }
//        }
//
//
//    }


    public String sendTemplateMessage(String accessToken,Map<String,Object> params){
        String url = sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN",accessToken);
        String json = HttpUtil.post(replaceUrl, params);
        return json;
    }

//    public String sendAllByTab(){
//        String url = sendAllByTabURL;
//        String replaceUrl = url.replace("ACCESS_TOKEN",getWXToken());
//        Map<String,Object> param = new HashMap<>();
//        Map<String,Object> map1 = new HashMap<>();
//        Map<String,Object> map2 = new HashMap<>();
//        map1.put("is_to_all",true);
//        param.put("filter",map1);
//        String content = "公告发布通知"+"\n"+"重庆二季度单项竞价公告"+"\n"+"物料所属分类：废旧物资"
//                +"\n"+"公告发布时间：2023-05-06 11:17:00"+"\n"+"报名结束时间：2023-05-07 11:17:00"
//                +"\n"+"备注：有意向参与竞价的企业请及时访问\"重庆机电数智采购平台\"官网登录参与报名";
//        map2.put("content",content);
//        param.put("text",map2);
//        param.put("msgtype","text");
//        String json = doPost(replaceUrl,param);
//        return json;
//    }

    /**
     * 获取所有关注者(openid列表)
     */
    public Integer getOpenIdList(List<String> openidList, String accessToken, String nextOpenid) {
        Map<String, Object> params = new HashMap<>();
        params.put("access_token", accessToken);
        params.put("next_openid", nextOpenid);
        String jsonString = HttpUtil.get(getUserURL, params);
        JSONObject jsonObject = JSONObject.parseObject(jsonString);
        JSONArray array = jsonObject.getJSONObject("data").getJSONArray("openid");
        List<String> currentOpenidList = array.toJavaList(String.class);
        openidList.addAll(currentOpenidList);
        Integer total = (Integer) jsonObject.get("total");
        if (openidList.size() < total) {
            nextOpenid = (String) jsonObject.get("next_openid");
            getOpenIdList(openidList,accessToken,nextOpenid);
        }
        return total;
    }

    public void sendTemplateMessage(WxNoticeTemplate wxTemplate){
        String url = sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN",getWXToken());
        Map<String,Object> param = new HashMap<>();
        Map<String,Object> data = new HashMap<>();
        param.put("template_id",noticeTemplateId);
        param.put("appid",appID);
        param.put("data",data);
        String title = wxTemplate.getKeyword1();
        String substring = title.substring(title.length() - 2, title.length());
        if(!substring.equals("公告")) title=title+"公告";
        data.put("title",new WxTemplateVO(title));
        param.put("touser","oo8Ve5jESzxuT1MA1QWStKSeAs5o");
        HttpUtil.post(replaceUrl, param);
    }


    public String sendTemplateMessage(String accessToken,String openId,Map<String,Object> params){
        params.put("touser",openId);
        String url = sendTemplateMessageURL;
        String replaceUrl = url.replace("ACCESS_TOKEN",accessToken);
        String result = HttpUtil.post(replaceUrl, params);
        return result;
    }


    /**
     * 调用接口 post
     * @param apiPath
     */
    public String doPost(String apiPath,Map<String,Object> paramMap){
        PrintWriter out = null;
        InputStream is = null;
        String result = null;
        try{
            URL url = new URL(apiPath);// 创建连接
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("accept", "*/*"); // 设置接收数据的格式
            connection.setRequestProperty("connection", "Keep-Alive"); // 设置发送数据的格式
            connection.setRequestProperty("user-agent","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setDoOutput(true);
            connection.setDoInput(true);

            out = new PrintWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8")); // utf-8编码
            out.print(JSONObject.toJSON(paramMap));
            out.flush();
            out.close();

            // 读取响应
            is = connection.getInputStream();
            int length = (int) connection.getContentLength();// 获取长度
            if (length != -1) {
                byte[] data = new byte[length];
                byte[] temp = new byte[512];
                int readLen = 0;
                int destPos = 0;
                while ((readLen = is.read(temp)) > 0) {
                    System.arraycopy(temp, 0, data, destPos, readLen);
                    destPos += readLen;
                }
                result = new String(data, "UTF-8"); // utf-8编码
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }



    public JSONObject uploadnews(String title,String bizId,String category,String pubTime,String endRegisTime){
        String redisToken = getWXToken();
        String urlStr = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=ACCESS_TOKEN";
        String replaceUrl = urlStr.replace("ACCESS_TOKEN", redisToken);
        Map<String,Object> param = new HashMap<>();
        List<Map<String,Object>> articles = new ArrayList<>();
        Map<String,Object> article = new HashMap<>();
        article.put("thumb_media_id","ipmef7CpnP3K8-31NCqgCruNUBQKRGDhjD21FhHETmAQqm1zsQag-dvRjsRGxnXJ");
        article.put("title",title+"发布通知");
        article.put("show_cover_pic",1);
        article.put("content_source_url","http://139.159.250.89:8807/fvue/viewPlat/NoticeDetils?id="+bizId);
        String content = "<h1>"+title+"</h1>"+"<p>物料所属分类："+category+"</p>"
                +"<p>公告发布时间："+pubTime+"</p>"+"<p>报名结束时间："+endRegisTime+"</p>"
                +"<p>备注：有意向参与竞价的企业请及时点击下方\"阅读原文\"或访问\"重庆机电数智采购平台\"官网登录参与报名</p>";
        article.put("content",content);
        articles.add(article);
        param.put("articles",articles);
        String json = doPost(replaceUrl,param);
        return JSONObject.parseObject(json);
    }

    public void uploadNewsAndSendAll(String title,String bizId,String category,String pubTime,String endRegisTime){
        String redisToken = getWXToken();
        String urlStr = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=ACCESS_TOKEN";
        String replaceUrl = urlStr.replace("ACCESS_TOKEN", redisToken);
        Map<String,Object> param = new HashMap<>();
        List<Map<String,Object>> articles = new ArrayList<>();
        Map<String,Object> article = new HashMap<>();
        article.put("thumb_media_id","ipmef7CpnP3K8-31NCqgCruNUBQKRGDhjD21FhHETmAQqm1zsQag-dvRjsRGxnXJ");
        article.put("title",title+"发布通知");
        article.put("show_cover_pic",1);
        article.put("content_source_url","http://139.159.250.89:8807/fvue/viewPlat/NoticeDetils?id="+bizId);
        String content = "<h1>"+title+"</h1>"+"<p>物料所属分类："+category+"</p>"
                +"<p>公告发布时间："+pubTime+"</p>"+"<p>报名结束时间："+endRegisTime+"</p>"
                +"<p>备注：有意向参与竞价的企业请及时点击下方\"阅读原文\"或访问\"重庆机电数智采购平台\"官网登录参与报名</p>";
        article.put("content",content);
        articles.add(article);
        param.put("articles",articles);
        String json = doPost(replaceUrl,param);
        JSONObject jsonObject = JSONObject.parseObject(json);
        if(BeanUtils.isNotEmpty(jsonObject)){
            if(BeanUtils.isNotEmpty(jsonObject.get("media_id"))){
                //如果返回状态码为0说明发送上传成功
                sendAllByTab(redisToken,jsonObject.get("media_id").toString());
            }
        }
    }


    public String sendAllByTab(){
        String url = sendAllByTabURL;
        String replaceUrl = url.replace("ACCESS_TOKEN",getWXToken());
        Map<String,Object> param = new HashMap<>();
        Map<String,Object> map1 = new HashMap<>();
        Map<String,Object> map2 = new HashMap<>();
        map1.put("is_to_all",true);
        param.put("filter",map1);
        map2.put("media_id","uVvtRFku_LsM9BmHYMYddAYhdanPmFhw7MVcRNHDmlekXNCnhmcVuGGoyKop01Kv");
        param.put("mpnews",map2);
        param.put("msgtype","mpnews");
        String json = doPost(replaceUrl,param);
        return json;
    }

    public String sendAllByTab(String token,String mediaId){
        String url = sendAllByTabURL;
        String replaceUrl = url.replace("ACCESS_TOKEN",token);
        Map<String,Object> param = new HashMap<>();
        Map<String,Object> map1 = new HashMap<>();
        Map<String,Object> map2 = new HashMap<>();
        map1.put("is_to_all",true);
        param.put("filter",map1);
        map2.put("media_id",mediaId);
        param.put("mpnews",map2);
        param.put("msgtype","mpnews");
        String json = doPost(replaceUrl,param);
        return json;
    }


    public void wxEmpower(HttpServletRequest request, HttpServletResponse response) throws Exception {
        //第一步：引导用户进入授权页面同意授权，获取code
        StringBuilder builder = new StringBuilder("https://open.weixin.qq.com/connect/oauth2/authorize?appid=");
        builder.append(appID);
        builder.append("&redirect_uri=");
//        builder.append(URLEncoder.encode(backUrl));//开发文档要求转换
        builder.append(URLEncoder.encode("http://agau6a.natappfree.cc/sso/weixinPublic"));//开发文档要求转换
        builder.append("&response_type=code");
        builder.append("&scope=snsapi_userinfo");
        builder.append("&state=STATE#wechat_redirect");
        //授权页面地址
        String url=builder.toString();
        //重定向到授权页面
        response.sendRedirect(url);
    }



    public CommonResult wxCallBack(String code, Model model) throws Exception{
        System.out.println("code:" + code);
        //获取code后，请求以下链接获取access_token
        StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/sns/oauth2/access_token?appid=");
        builder.append(appID);
        builder.append("&secret=");
        builder.append(appSecret);
        builder.append("&code=");
        builder.append(code);
        builder.append("&grant_type=authorization_code");

        //通过网络请求方法来请求上面这个接口
        //将StringBuilder转换成String
        String url=builder.toString();
        JSONObject jsonObject = doGetJson(url);

        System.out.println("==========================jsonObject" + jsonObject);
        //从返回的JSON数据中取出access_token和openid，拉取用户信息时用
        String token = jsonObject.getString("access_token");
        String openid = jsonObject.getString("openid");

        //拉取用户信息(需scope为 snsapi_userinfo)
        StringBuilder builder1 = new StringBuilder("https://api.weixin.qq.com/sns/userinfo?access_token=");
        builder1.append(token);
        builder1.append("&openid=");
        builder1.append(openid);
        builder1.append("&lang=zh_CN");
        //通过网络请求方法来请求上面这个接口
        //将StringBuilder转换成String
        String infoUrl=builder1.toString();
        JSONObject userInfo = doGetJson(infoUrl);

        System.out.println("userInfo=======" + userInfo);
        //查看数据库是否存在相对应用户
        try {
            CommonResult<UserVo> user = userManager.getUserByOpenId(openid);
            if (BeanUtils.isNotEmpty(user.getValue())) {
                //已绑定
                model.addAttribute("info",userInfo);
                model.addAttribute("name", user.getValue().getFullname());
                CommonResult response = new CommonResult(true,"已绑定用户",user);
                return response;
            } else {
                //未绑定
                model.addAttribute("openid", openid);
                model.addAttribute("info",userInfo);
                Map<String, Object> dataMap = new HashMap<>();
                dataMap.put("openid", openid);
                dataMap.put("info", userInfo);
                CommonResult response = new CommonResult(true,"授权成功，请绑定用户",dataMap);
                return response;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResult response = new CommonResult(false,"授权失败");
        return response;
    }


    public static JSONObject doGetJson(String url) throws Exception{
        JSONObject jsonObject = null;

        // 创建HttpClient实例
        HttpClient client =  HttpClientBuilder.create().build();
        // 根据URL创建HttpGet实例
        HttpGet get = new HttpGet(url);
        // 执行get请求，得到返回体
        HttpResponse response = client.execute(get);
        System.out.println(response);
        //从response里面拿自己想要的结果
        HttpEntity entity = response.getEntity();
        if(entity != null){
            String result = EntityUtils.toString((HttpEntity) entity,"UTF-8");
            jsonObject = JSONObject.parseObject(result);
        }
        //把链接释放掉
//        HttpGet.releaseConnection();
        return jsonObject;
    }


    public JSONObject getOpenIdByCode(String code){
        StringBuilder builder = new StringBuilder(getOpenIdURL);
        builder.append("?appid=");
        builder.append(appID);
        builder.append("&secret=");
        builder.append(appSecret);
        builder.append("&js_code=");
        builder.append(code);
        builder.append("&grant_type=authorization_code");

        //通过网络请求方法来请求上面这个接口
        //将StringBuilder转换成String
        String url=builder.toString();
        JSONObject jsonObject = null;
        try {
            jsonObject = doGetJson(url);
        } catch (Exception e) {
            throw new BaseException("获取OpenId失败:",e);
        }

        System.out.println("==========================jsonObject" + jsonObject);
        return jsonObject;
    }


//    public void wxBindingSysUser(String openId,String account,String password){
//        //1.根据openId判断该微信是否绑定系统用户
//        CommonResult<UserVo> userByOpenId = userManager.getUserByOpenId(openId);
//        if(BeanUtils.isNotEmpty(userByOpenId.getValue())) throw new BaseException("您的微信已绑定用户...");
//
//        //2.根据账号密码查询是否存在该用户
//        QueryWrapper<User> userQW = new QueryWrapper<>();
//        userQW.eq("ACCOUNT_",account).eq("PASSWORD_",passwordEncoder.encode(password)).eq("is_dele_","0");
//        User user = userManager.getUserAndUnite(userQW);
//        if(!BeanUtils.isNotEmpty(user)) throw new BaseException("账号或密码错误!");
//
//        //3.判断该用户是否已绑定微信
//        if(BeanUtils.isNotEmpty(user.getOpenId())) throw new BaseException("该用户已绑定微信...");
//
//        //4.如果没有绑定就把该openId绑定该用户
//        UserUnite userUnite = new UserUnite();
//        userUnite.setUserId(user.getId());
//        userUnite.setOpenId(openId);
//        userUniteManager.updateUserUnite(userUnite);
//    }

    public void unBindingWx(String openId){
        QueryWrapper<UserUnite> userUniteQW = new QueryWrapper<>();
        userUniteQW.eq("OPEN_ID_",openId);
        userUniteManager.remove(userUniteQW);
    }


}
