package com.artfess.cgpt.foreignApi.controller;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.manager.impl.PurchasingApplicationManagerImpl;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.utils.HttpUtil;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/5/22 15:45
 */
@RestController
@Api(tags = "对外接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RequestMapping("api")
public class ForeignApiController {

    @Value("${zsj.checkTokenKeyUrl}")
    private String checkTokenKeyUrl;
    @Value("${zsj.getUserByTokenUrl}")
    private String getUserByTokenUrl;

    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private BizMaterialCategoryManager matCategoryManager;
    @Autowired
    private BizMaterialManager materialManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;


    @PostMapping("/valid/{tokenKey}")
    @ApiOperation(value = "M-调用门户网站校验tokenKey", httpMethod = "POST")
    public CommonResult validTokenKey(@PathVariable String tokenKey) throws Exception {
        if(BeanUtils.isEmpty(tokenKey)) return new CommonResult(false,"tokenKey不能为空");

        //校验tokenKey并拿到token
        Map<String,Object> map = new HashMap<>();
        map.put("tokenKey",tokenKey);
        String token = HttpUtil.get(checkTokenKeyUrl,map);

        JSONObject jsonObject = JSON.parseObject(token);
        Object value = jsonObject.get("value");
        if(BeanUtils.isEmpty(value)) return new CommonResult(false,"无效的token");

        //根据token获取用户信息
        Map<String,String> tokenMap = new HashMap<>();
        tokenMap.put("Authorization","Bearer "+value.toString());
        String userInfo = HttpUtil.post(getUserByTokenUrl,null,tokenMap,"application/json",3000,3000,"UTF-8");

        JSONObject userJsonObject = JSON.parseObject(userInfo);
        Object resultObj = userJsonObject.get("value");
        if(BeanUtils.isEmpty(resultObj)) return new CommonResult<>(false,"无效的token");
        JSONObject result = JSON.parseObject(resultObj.toString());

        return new CommonResult<>(true,"操作成功",result);
    }

    @GetMapping("/createTokenKey")
    @ApiOperation(value = "M-创建tokenKey并存入redis")
    public CommonResult createTokenKey() {
        String tokenKey = foreignCallService.createTokenKey();
        return new CommonResult<>(true, "操作成功", tokenKey);
    }

    @GetMapping("/checkTokenKey")
    @ApiOperation(value = "M-校验tokenKey并返回token")
    public CommonResult checkTokenKey(@RequestParam(name = "tokenKey") String tokenKey) {
        if (BeanUtils.isEmpty(tokenKey)) return new CommonResult(false, "无效的tokenKey");
        CommonResult result = foreignCallService.checkToken(tokenKey);
        return result;
    }

    @PostMapping("/getUserByToken")
    @ApiOperation(value = "M-根据token获取用户信息")
    public CommonResult getUserByToken() {
        return foreignCallService.getUserByTOKEN();
    }

    @PostMapping("/pushSucBidNotice")
    @ApiOperation(value = "M-推送中选公示到门户（物资）")
    public CommonResult pushSucBidNotice(@RequestBody List<MatApprovalDetails> detailedList) {
//        foreignCallService.pushSucBidNotice(detailedList);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/setMasterOrg")
    @ApiOperation(value = "M-变更人员主组织", httpMethod = "POST")
    public Response setMasterOrg(@RequestBody cn.hutool.json.JSONObject param) {
        try {
            orgManager.setMaster(param.get("account").toString(),param.get("orgCode").toString());
        } catch (Exception e) {
            e.printStackTrace();
            return Response.error("601",e.getMessage());
        }

        return Response.ok();
    }

    @PostMapping("/pushWxMessage")
    @ApiOperation(value = "M-推送微信公众号消息", httpMethod = "POST")
    public Response pushWxMessage(@RequestBody WxNoticeTemplate wxNoticeTemplate) {
        cn.hutool.json.JSONObject result = foreignCallService.pushWxMessage(wxNoticeTemplate);
        return Response.ok(result);
    }

//    @PostMapping("/enterprise/querys")
//    @ApiOperation(value = "M-获取企业信息")
//    public CommonResult<List<Enterprise>> querysEnterprise(@ApiParam(name = "queryBody", value = "实体查询类") @RequestBody EnterpriseQueryVO queryBody) {
//        List<Enterprise> result = enterpriseManager.queryAll(queryBody);
//        return new CommonResult<>(true, "查询成功", result);
//    }

    @PostMapping("/user/query")
    @ApiOperation(value = "M-获取主数据用户信息")
    public CommonResult queryUser(@RequestBody User queryVO) {
        cn.hutool.json.JSONObject result = foreignCallService.queryUser(queryVO);
        if(BeanUtils.isNotEmpty(result)){
            if(BeanUtils.isNotEmpty(result.getStr("code"))){
                if(result.getStr("code").equals("0")){
                    return new CommonResult<>(true, "查询成功",result.get("data"));
                }
                return new CommonResult<>(false, "查询失败："+result.getStr("msg"));
            }
            return new CommonResult<>(false, "查询失败："+result);
        }
        return new CommonResult<>(false, "查询失败");
    }

    @PostMapping("/matCategory/saveOrUpdate")
    @ApiOperation(value = "物料分类导入")
    public Response saveOrUpdateMatCategory(@RequestBody cn.hutool.json.JSONObject param) {
        System.out.println("导入物料分类报文:"+ JSONUtil.toJsonStr(param));
        return matCategoryManager.saveOrUpdateByApi(param);
    }

    @PostMapping("/material/saveOrUpdate")
    @ApiOperation(value = "物料数据导入")
    public Response saveOrUpdateMaterial(@RequestBody cn.hutool.json.JSONObject param) {
        System.out.println("导入物料报文:"+ JSONUtil.toJsonStr(param));
        return materialManager.saveOrUpdateByApi(param);
    }

    @PostMapping("/enterprise/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新组织")
    public Response saveOrUpdateEnterprise(@RequestBody cn.hutool.json.JSONObject param) {
        System.out.println("导入组织报文:"+ JSONUtil.toJsonStr(param));
        return enterpriseManager.saveOrUpdateByApi(param);
    }

    @PostMapping("/user/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新用户")
    public Response saveOrUpdateUser(@RequestBody cn.hutool.json.JSONObject param) {
        System.out.println("导入用户报文:"+ JSONUtil.toJsonStr(param));
        return enterpriseManager.saveOrUpdateUserByApi(param);
    }

    @PostMapping("/pur/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新采购申请单")
    public Response saveOrUpdatePur(@RequestBody cn.hutool.json.JSONObject param) {
        System.out.println("导入采购申请单报文:"+ JSONUtil.toJsonStr(param));
        return purchasingApplicationManager.saveOrUpdateByApi(param);
    }

}
