package com.artfess.cgpt.expert.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资质信息表，专家库_资质库中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizExpertDatabaseQualificationLabel对象", description="资质信息表，专家库_资质库中间表")
@Data
@TableName("biz_expert_database_qualification_label")
public class BizExpertDatabaseQualificationLabel extends BaseModel<BizExpertDatabaseQualificationLabel> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "专家库ID（关联专家库表ID）")
    @TableField("EXPERT_DATABASE_ID_")
    private String expertDatabaseId;

    @ApiModelProperty(value = "资质库ID（关联资质库表ID）")
    @TableField("QUALIFICATION_LABEL_ID_")
    private String qualificationLabelId;


}
