package com.artfess.cgpt.expert.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 专家所属分类表，专家库_专家分类中间表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizExpertDatabaseExpertType对象", description="专家所属分类表，专家库_专家分类中间表")
@Data
@TableName("biz_expert_database_expert_type")
public class BizExpertDatabaseExpertType extends BaseModel<BizExpertDatabaseExpertType> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "专家库ID（关联专家库表ID）")
    @TableField("EXPERT_DATABASE_ID_")
    private String expertDatabaseId;

    @ApiModelProperty(value = "专家分类ID（关联专家分类表ID）")
    @TableField("EXPERT_TYPE_ID_")
    private String expertTypeId;


}
