package com.artfess.cgpt.evaluation.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 评标项目表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizEvaluationItem对象", description="评标项目表")
@TableName("biz_evaluation_item")
@Data
public class BizEvaluationItem extends BizModel<BizEvaluationItem> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "父项ID")
    @TableField("PCODE_")
    private String pcode;

    @ApiModelProperty(value = "父项名称")
    @TableField("PNAME_")
    private String pname;

    @ApiModelProperty(value = "项目编码（使用流水号自动生成，格式：yyyy00001）")
    @TableField("SUBJECT_CODE_")
    private String subjectCode;

    @ApiModelProperty(value = "项目名称")
    @TableField("SUBJECT_NAME_")
    private String subjectName;

    @ApiModelProperty(value = "子项目")
    @TableField(exist = false)
    private List<BizEvaluationItem> children;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Long sn;

    @ApiModelProperty(value = "是否有子节点")
    @TableField("HAS_CHILDREN")
    private String hasChildren;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "状态（0：禁用，1：启用）")
    @TableField("STATUS_")
    private Integer status;

}
