package com.artfess.cgpt.evaluation.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.evaluation.dao.BizEvaluationSystemDescriptionDao;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemUseOrg;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 评标体系明细表，只有综合评标法有明细，最低价评标法无明细 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizEvaluationSystemDescriptionManagerImpl extends BaseManagerImpl<BizEvaluationSystemDescriptionDao, BizEvaluationSystemDescription> implements BizEvaluationSystemDescriptionManager {

    @Autowired
    private BizEvaluationSystemManager evaluationSystemManager;

    @Override
    public List<BizEvaluationSystemDescription> selectBySysId(String sysId) {
        return baseMapper.selectBySysId(sysId);
    }

    //2024-07-05 10:10
//    @Override
//    public BizEvaluationSystem getEvaScore(BizEvaluationSystemDescription param) {
//        if(BeanUtils.isEmpty(param) || BeanUtils.isEmpty(param.getEvaluationSystemId())) {
//            return new BizEvaluationSystem();
//        }
//        BizEvaluationSystem result = evaluationSystemManager.getById(param.getEvaluationSystemId());
//        String noticeDetailId = BeanUtils.isNotEmpty(param.getNoticeDetailId())?param.getNoticeDetailId():null;
//        //查询评分明细
//        result.setDescriptionList(baseMapper.selectBySysIdAndScore(result.getId()
//                ,param.getNoticeId(),param.getOrgId(),noticeDetailId));
//        return result;
//    }

    @Override
    public BizEvaluationSystem getEvaScore(BizEvaluationSystemDescription param) {
        if(BeanUtils.isEmpty(param) || BeanUtils.isEmpty(param.getNoticeId())) {
            return new BizEvaluationSystem();
        }
        LambdaQueryWrapper<BizEvaluationSystem> evaSystemQW = new LambdaQueryWrapper<>();
        evaSystemQW.eq(BizEvaluationSystem::getNoticeId,param.getNoticeId())
                .eq(BizEvaluationSystem::getNoticeType,param.getNoticeType())
                .orderByDesc(BizEvaluationSystem::getPreparedTime)
                .last("limit 1");
        BizEvaluationSystem result = evaluationSystemManager.getBaseMapper().selectOne(evaSystemQW);
        String noticeDetailId = BeanUtils.isNotEmpty(param.getNoticeDetailId())?param.getNoticeDetailId():null;
        //查询评分明细
        result.setDescriptionList(baseMapper.selectBySysIdAndScore(result.getId()
                ,param.getNoticeId(),param.getOrgId(),noticeDetailId, ContextUtil.getCurrentUserId()));
        return result;
    }


}
