package com.artfess.cgpt.evaluation.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 评标体系明细表，只有综合评标法有明细，最低价评标法无明细 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
public interface BizEvaluationSystemDescriptionManager extends BaseManager<BizEvaluationSystemDescription> {

    /**
     * 根据评标体系id查询
     * @param sysId 评标体系ID
     * @return
     */
    List<BizEvaluationSystemDescription> selectBySysId(String sysId);

    /**
     * 查询数据（评分联查）
     * @param param
     * @return
     */
    BizEvaluationSystem getEvaScore(BizEvaluationSystemDescription param);

}
