package com.artfess.cgpt.contract.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Description:合同明细表
 * @Author: Rong Tao
 * @Date: 2024/4/11 15:21
 */
@ApiModel(value="ContractItem对象", description="合同明细表")
@TableName("biz_contract_item")
@Data
public class ContractItem extends BizNoModel<ContractItem> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "关联合同表合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "序号")
    @TableField("SORT_")
    private Integer sort;

    @ApiModelProperty(value = "成交通知ID")
    @TableField("WIN_NOTICE_ID_")
    private String winNoticeId;

    @ApiModelProperty(value = "成交通知明细ID")
    @TableField("WIN_NOTICE_DETAIL_ID_")
    private String winNoticeDetailId;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_NUMBER_")
    private String noticeNumber;

    @ApiModelProperty(value = "采购立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private String noticeType;

    @ApiModelProperty(value = "采购立项明细ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "采购申请编号")
    @TableField("PURCHASING_APPLICATION_CODE_")
    private String purchasingApplicationCode;

    @ApiModelProperty(value = "采购申请明细ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_DETAIL_ID_")
    private String purchasingApplicationDetailId;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    private String planCode;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "平台物料号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类CODE，关联物料分类CODE")
    @TableField("MAT_CATEGORY_")
    private String matCategory;

    @ApiModelProperty(value = "物料编码")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "采购方式（使用字典，1：平台招标，2：企业招标，3：企业线下定价）")
    @TableField("PROCUREMENT_METHOD_")
    private String procurementMethod;

    @ApiModelProperty(value = "招标方式（使用字典，1：招标采购:2：邀请招标采购:3：竞争性谈判:4：竞价采购:5：询价采购:6：单一来源采购:7：多源采购）")
    @TableField("APPLICATION_METHOD_")
    private String applicationMethod;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private String hasQualification;

    @ApiModelProperty(value = "计划价格")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "有无资质要求（1：无，2：有）")
    @TableField("HAS_QUALIFICATIONS_")
    private Integer hasQualifications;

    @ApiModelProperty(value = "是否集中采购（0：自采，1：集采）")
    @TableField("MAT_IF_PLAT_")
    private Integer matIfPlat;

    @ApiModelProperty(value = "数量（默认值：1）")
    @TableField("NUM_")
    private Double num;

    @ApiModelProperty(value = "税率（整数）")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "不含税单价（元）")
    @TableField("CONTR_PRICE_")
    private BigDecimal contrPrice;

    @ApiModelProperty(value = "不含税金额（元）")
    @TableField("CONTR_AMOUNT_")
    private BigDecimal contrAmount;

    @ApiModelProperty(value = "含税单价（元）")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税金额（元）")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "税额")
    @TableField("TAX_VALUE_")
    private BigDecimal taxValue;

    @ApiModelProperty(value = "交货地点")
    @TableField("UNLOAD_ADDRESS_")
    private String unloadAddress;

    @ApiModelProperty(value = "供应商补充说明")
    @TableField("VENDOR_NOTE_")
    private String vendorNote;

    @ApiModelProperty(value = "交货期")
    @TableField("REQ_DATE_")
    private LocalDate reqDate;

    @ApiModelProperty(value = "企业补充说明")
    @TableField("PUR_NOTE_")
    private String purNote;

    @ApiModelProperty(value = "价格执行开始时间")
    @TableField("CONTR_START_DATE_")
    private LocalDate contrStartDate;

    @ApiModelProperty(value = "价格执行结束时间")
    @TableField("CONTR_END_DATE_")
    private LocalDate contrEndDate;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

}
