package com.artfess.cgpt.contract.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.contract.dao.ContractItemDao;
import com.artfess.cgpt.contract.manager.ContractItemManager;
import com.artfess.cgpt.contract.model.ContractItem;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrderDetail;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/4/11 15:24
 */
@Service
public class ContractItemManagerImpl extends BaseManagerImpl<ContractItemDao, ContractItem> implements ContractItemManager {

    @Override
    public void deleByContractId(String contractId) {
        QueryWrapper<ContractItem> wrapper = new QueryWrapper<>();
        wrapper.eq("CONTRACT_ID_",contractId);
        wrapper.eq("IS_DELE_","0");
        this.remove(wrapper);
    }

    @Override
    public List<ContractItem> getByContractId(String contractId) {
        LambdaQueryWrapper<ContractItem> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ContractItem::getContractId,contractId);
        return super.list(wrapper);
    }

}
