package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description: 报价模版明细表
 * @Author: Rong Tao
 * @Date: 2024/3/15 18:21
 */
@ApiModel(value="QuotationTemplateDetail对象", description="报价模版明细表")
@Data
@TableName("biz_quotation_template_detail")
public class QuotationTemplateDetail extends BizModel<QuotationTemplateDetail> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报价模版ID（关联报价模版表ID）")
    @TableField("TEMPLATE_ID_")
    private String templateId;

    @ApiModelProperty(value = "报价列名称")
    @TableField("QUO_ARRANGE_")
    private String quoArrange;

    @ApiModelProperty(value = "是否必填（0：否，1：是）")
    @TableField("IS_REQUIRED_")
    private Boolean isRequired;

    @ApiModelProperty(value = "招标录入项（0：否，1：是）")
    @TableField("BECKON_ENTRY_")
    private Boolean beckonEntry;

    @ApiModelProperty(value = "投标录入项（0：否，1：是）")
    @TableField("THROW_ENTRY_")
    private Boolean throwEntry;

    @ApiModelProperty(value = "投标显示项（0：否，1：是）")
    @TableField("THROW_SHOW_")
    private Boolean throwShow;

    @ApiModelProperty(value = "评标显示项（0：否，1：是）")
    @TableField("EVALUATION_SHOW_")
    private Boolean evaluationShow;

    @ApiModelProperty(value = "价格录入项（0：否，1：单价，2：总价）")
    @TableField("PRICE_ENTRY_")
    private Integer priceEntry;

    @ApiModelProperty(value = "来源类型")
    @TableField("SOURCE_TYPE_")
    private String sourceType;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "参数值（当前报价）")
    @TableField(exist = false)
    private String value;

    @ApiModelProperty(value = "报价参数值1（第1轮）")
    @TableField(exist = false)
    private String quoValue1;
    @ApiModelProperty(value = "报价参数值2（第2轮）")
    @TableField(exist = false)
    private String quoValue2;
    @ApiModelProperty(value = "报价参数值3（第3轮）")
    @TableField(exist = false)
    private String quoValue3;
    @ApiModelProperty(value = "报价参数值4（第4轮）")
    @TableField(exist = false)
    private String quoValue4;

}
