package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Description:定标管理表
 * @Author: Rong Tao
 * @Date: 2024/4/25 18:16
 */
@ApiModel(value="Calibration对象", description="定标管理表")
@TableName("biz_calibration")
@Data
public class Calibration extends BizModel<Calibration> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评标记录ID（关联评标记录表ID）")
    @TableField("EVALUATION_ID_")
    private String evaluationId;

    @ApiModelProperty(value = "操作人ID")
    @TableField("OPERATE_USER_ID_")
    private String operateUserId;

    @ApiModelProperty(value = "操作人姓名")
    @TableField("OPERATE_USER_NAME_")
    private String operateUserName;

    @ApiModelProperty(value = "操作时间")
    @TableField("OPERATE_TIME_")
    private LocalDateTime operateTime;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "供应商ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商编码")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "中标金额")
    @TableField("WIN_BID_PRICE_")
    private BigDecimal winBidPrice;

    @ApiModelProperty(value = "得分")
    @TableField("SCORE_")
    private BigDecimal score;

    @ApiModelProperty(value = "排名")
    @TableField("RANK_")
    private Integer rank;

    @ApiModelProperty(value = "供货份额分配率（%）")
    @TableField("SHARE_ALLOCATION_RATE_")
    private BigDecimal shareAllocationRate;

    @ApiModelProperty(value = "供货数量")
    @TableField("SHARE_ALLOCATION_NUM_")
    private BigDecimal shareAllocationNum;

}
