package com.artfess.cgpt.bidding.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * 当前报价表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@ApiModel(value="BizBiddingQuotation对象", description="当前报价表")
@TableName("biz_bidding_quotation")
@Data
public class BizBiddingQuotation extends BizNoModel<BizBiddingQuotation> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报价轮次（关联采购立项报价轮次）")
    @TableField("QUOTATION_ROUNDS_")
    @Excel(name = "报价轮次")
    private Integer quotationRounds;

    @ApiModelProperty(value = "报价批次号(自动生成)")
    @TableField("QUOTATION_BACTH_NUM_")
    private String quotationBacthNum;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private String noticeType;

    @ApiModelProperty(value = "采购立项明细ID，关联采购立项明细表ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "报价用户ID")
    @TableField("QUOTATION_USER_ID_")
    private String quotationUserId;

    @ApiModelProperty(value = "报价用户联系电话")
    @TableField("QUOTATION_USER_PHONE_")
    private String quotationUserPhone;

    @ApiModelProperty(value = "报价用户姓名")
    @TableField("QUOTATION_USER_NAME_")
    private String quotationUserName;

    @ApiModelProperty(value = "报价用户账号")
    @TableField("QUOTATION_USER_ACCOUNT_")
    private String quotationUserAccount;

    @ApiModelProperty(value = "报价公司ID")
    @TableField("QUOTATION_COMPANY_ID_")
    private String quotationCompanyId;

    @ApiModelProperty(value = "报价公司名称")
    @TableField("QUOTATION_COMPANY_NAME_")
    @Excel(name = "报价供应商")
    private String quotationCompanyName;

    @ApiModelProperty(value = "报价公司编号")
    @TableField("QUOTATION_COMPANY_CODE_")
    private String quotationCompanyCode;

    @ApiModelProperty(value = "报价编号")
    @TableField("QUOTATION_NUM_")
    private Integer quotationNum;

    @ApiModelProperty(value = "结算方式（1：现金，2：承兑）")
    @TableField("QUOTATION_METHOD_")
    private Integer quotationMethod;

    @TableField(exist = false)
    @Excel(name = "报价方式")
    private String quotationMethodStr;

    @ApiModelProperty(value = "是否含税（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @TableField(exist = false)
    @Excel(name = "是否含税")
    private String isTaxStr;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    @Excel(name = "税率(%)")
    private Integer taxRate;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    @Excel(name = "数量")
    private BigDecimal matNum;

    @ApiModelProperty(value = "报价单价，当前报价")
    @TableField("QUOTATION_PRICE_")
    @Excel(name = "报价单价(元)")
    private BigDecimal quotationPrice;

    @ApiModelProperty(value = "报价总额（报价单价*数量），当前报价")
    @TableField("QUOTATION_AMOUNT_")
    @Excel(name = "报价总价(元)")
    private BigDecimal quotationAmount;

    @ApiModelProperty(value = "报价金额（单价），第1轮")
    @TableField(exist = false)
    private BigDecimal quoPrice1;
    @ApiModelProperty(value = "报价金额（单价），第2轮")
    @TableField(exist = false)
    private BigDecimal quoPrice2;
    @ApiModelProperty(value = "报价金额（单价），第3轮")
    @TableField(exist = false)
    private BigDecimal quoPrice3;
    @ApiModelProperty(value = "报价金额（单价），第4轮")
    @TableField(exist = false)
    private BigDecimal quoPrice4;

    @ApiModelProperty(value = "报价时间")
    @TableField("QUOTATION_TIME_")
    private LocalDateTime quotationTime;

    @ApiModelProperty(value = "报价时间戳")
    @TableField("QUOTATION_TIMER_")
    private Long quotationTimer;

    @ApiModelProperty(value = "送货地址")
    @TableField(exist = false)
    @Excel(name = "送货地址")
    private String unloadAddress;

    @ApiModelProperty(value = "企业补充说明")
    @TableField(exist = false)
    @Excel(name = "企业补充说明")
    private String purNote;

    @ApiModelProperty(value = "投标补充说明")
    @TableField("TENDER_EXPLAIN_")
    @Excel(name = "供应商补充说明")
    private String tenderExplain;

    @ApiModelProperty(value = "总报价")
    @TableField(exist = false)
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "是否最低价（0：否，1：是）")
    @TableField(exist = false)
    private Integer isLowest;

    @ApiModelProperty(value = "是否评标（0：否，1：是）")
    @TableField(exist = false)
    private Integer isEva;

    @ApiModelProperty(value = "评标说明")
    @TableField(exist = false)
    private String evaExplain;

    @ApiModelProperty(value = "评标说明附件")
    @TableField(exist = false)
    private List<Accessory> evaExplainAccessory;

    @ApiModelProperty(value = "物料ID")
    @TableField(exist = false)
    private String matId;

    @ApiModelProperty(value = "平台物料编号")
    @TableField(exist = false)
    @Excel(name = "平台物料编号")
    private String matPlatcode;
    @ApiModelProperty(value = "物料分类编号")
    @TableField(exist = false)
    @Excel(name = "物料分类编号")
    private String matCategoryCode;
    @ApiModelProperty(value = "物料名称")
    @TableField(exist = false)
    @Excel(name = "物料名称")
    private String matName;
    @ApiModelProperty(value = "物料牌号")
    @TableField(exist = false)
    @Excel(name = "物料牌号")
    private String matMaterial;
    @ApiModelProperty(value = "规格型号")
    @TableField(exist = false)
    @Excel(name = "规格型号")
    private String matSpec;
    @ApiModelProperty(value = "计量单位")
    @TableField(exist = false)
    @Excel(name = "计量单位")
    private String matUnit;
    @ApiModelProperty(value = "品牌")
    @TableField(exist = false)
    @Excel(name = "品牌")
    private String matBrand;
    @ApiModelProperty(value = "基础扩展")
    @TableField(exist = false)
    @Excel(name = "基础扩展")
    private String matBaseExt;
    @ApiModelProperty(value = "其他扩展")
    @TableField(exist = false)
    @Excel(name = "其他扩展")
    private String matOtherExt;

    @ApiModelProperty(value = "物料编码")
    @TableField(exist = false)
    private String matCode;
    @ApiModelProperty(value = "总得分")
    @TableField(exist = false)
    private BigDecimal totalScore;
    @ApiModelProperty(value = "得分排名")
    @TableField(exist = false)
    private Integer rank;
    @ApiModelProperty(value = "是否中标（0.未中标，1.已中标）")
    @TableField(exist = false)
    private Integer isSel;
    @ApiModelProperty(value = "需求日期")
    @TableField(exist = false)
    private LocalDate demandDate;

    @ApiModelProperty(value = "报价模版明细数据集合")
    @TableField(exist = false)
    private List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList;

    @ApiModelProperty(value = "计划编号")
    @TableField(exist = false)
    @Excel(name = "计划编号")
    private String planCode;
    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField(exist = false)
//    @Excel(name = "承兑时间（月）")
    private Integer acceptanceTime;
    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField(exist = false)
//    @Excel(name = "挂账时间（月）")
    private Integer pendingTime;

    @ApiModelProperty(value = "报价轮次金额map")
    @TableField(exist = false)
    private List<Map<String, Object>> quoPriceMap;

    @ApiModelProperty(value = "采购申请明细ID")
    @TableField(exist = false)
    private String purchasingApplicationDetailId;

    @ApiModelProperty(value = "采购申请ID")
    @TableField(exist = false)
    private String purchasingApplicationId;

    @ApiModelProperty(value = "明细来源类型（1.项目库引入，2.项目申请引入，3.手工添加，4.自动生成）")
    @TableField(exist = false)
    private Integer projectSourceType;
    @ApiModelProperty(value = "项目申请ID（关联项目申请表ID）")
    @TableField(exist = false)
    private String projectInfoId;
    @ApiModelProperty(value = "项目库ID（关联项目库ID）")
    @TableField(exist = false)
    private String projectLedgerId;
    @ApiModelProperty(value = "项目库编号（关联项目库编号）")
    @TableField(exist = false)
    private String projectLedgerCode;
    @ApiModelProperty(value = "明细类型（1.服务，2.工程，3.设备，4.物资），默认4")
    @TableField(exist = false)
    private Integer detailType;
    @ApiModelProperty(value = "服务开始时间")
    @TableField(exist = false)
    private LocalDate serviceStartTime;
    @ApiModelProperty(value = "服务结束时间")
    @TableField(exist = false)
    private LocalDate serviceEndTime;
    @ApiModelProperty(value = "建筑面积（平方米）")
    @TableField(exist = false)
    private BigDecimal buildingArea;
    @ApiModelProperty(value = "建筑工程及公用系统(万元)")
    @TableField(exist = false)
    private BigDecimal constructionEngineering;
    @ApiModelProperty(value = "设备购置及安装(万元)")
    @TableField(exist = false)
    private BigDecimal equipmentProcurement;
    @ApiModelProperty(value = "其他费用(万元)")
    @TableField(exist = false)
    private BigDecimal otherExpenses;
    @ApiModelProperty(value = "设备分类（1.下料设备，2.铆焊设备，3.机加设备，4.热表设备，5.装配设备，6.检测设备，7.其他设备）")
    @TableField(exist = false)
    private Integer equipmentClassification;
    @ApiModelProperty(value = "技术要求（设备使用）")
    @TableField(exist = false)
    private String technicalRequirement;
    @ApiModelProperty(value = "项目状态（1.立项、2.在建、3.竣工 、4.终止）")
    @TableField(exist = false)
    private Integer projectStatus;
    @ApiModelProperty(value = "项目描述")
    @TableField(exist = false)
    private String projectDescript;
    @ApiModelProperty(value = "责任人ID")
    @TableField(exist = false)
    private String personLiableId;
    @ApiModelProperty(value = "责任人姓名")
    @TableField(exist = false)
    private String personLiableName;
    @ApiModelProperty(value = "责任人联系方式")
    @TableField(exist = false)
    private String personLiablePhone;
    @ApiModelProperty(value = "保证金（元），默认0")
    @TableField(exist = false)
    private BigDecimal bond;

}
