package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizNoModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:投标文件关联表
 * @Author: Rong Tao
 * @Date: 2024/6/17 10:44
 */
@ApiModel(value="BidDocuments对象", description="投标文件关联表")
@TableName("biz_bid_documents")
@Data
public class BidDocuments extends BizNoModel<BidDocuments> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项类型（1.物资，2.项目）")
    @TableField("PROJECT_APPROVAL_TYPE_")
    private Integer projectApprovalType;

    @ApiModelProperty(value = "采购立项ID（关联采购立项表ID）")
    @TableField("PROJECT_APPROVAL_ID_")
    private String projectApprovalId;

    @ApiModelProperty(value = "供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "上传时间")
    @TableField("UPLOAD_TIME_")
    private LocalDateTime uploadTime;

    @ApiModelProperty(value = "报价轮次（默认1）")
    @TableField("QUOTATION_ROUNDS_")
    private Integer quotationRounds;

    @ApiModelProperty(value = "文件类型（1.电子投标，2.线下投标），默认1")
    @TableField("BID_TYPE_")
    private Integer bidType;

    @ApiModelProperty(value = "投标文件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;
}
