package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotationHistory;
import com.artfess.cgpt.bidding.dao.BizBiddingQuotationHistoryDao;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationHistoryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.vo.MatApprovalDetailsExportVO;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 报价历史记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@Service
public class BizBiddingQuotationHistoryManagerImpl extends BaseManagerImpl<BizBiddingQuotationHistoryDao, BizBiddingQuotationHistory> implements BizBiddingQuotationHistoryManager {

    @Override
    public boolean saveByQuo(BizBiddingQuotation biddingQuotation) {
        BizBiddingQuotationHistory history = new BizBiddingQuotationHistory();
        if(BeanUtils.isNotEmpty(biddingQuotation.getQuotationRounds())) history.setQuotationRounds(biddingQuotation.getQuotationRounds());
        history.setAuctionBacthNum(biddingQuotation.getQuotationBacthNum());
        history.setNoticeId(biddingQuotation.getNoticeId());
        history.setNoticeType(biddingQuotation.getNoticeType());
        history.setQuotationNum(biddingQuotation.getQuotationNum());
        history.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
        history.setQuotationUserId(biddingQuotation.getQuotationUserId());
        history.setQuotationUserName(biddingQuotation.getQuotationUserName());
        history.setQuotationUserAccount(biddingQuotation.getQuotationUserAccount());
        if(BeanUtils.isNotEmpty(biddingQuotation.getQuotationUserPhone())) history.setQuotationUserPhone(biddingQuotation.getQuotationUserPhone());
        history.setQuotationCompanyId(biddingQuotation.getQuotationCompanyId());
        history.setQuotationCompanyCode(biddingQuotation.getQuotationCompanyCode());
        history.setQuotationCompanyName(biddingQuotation.getQuotationCompanyName());
        history.setQuotationMethod(biddingQuotation.getQuotationMethod());
        history.setIsTax(biddingQuotation.getIsTax());
        history.setTaxRate(biddingQuotation.getTaxRate());
        history.setQuotationPrice(biddingQuotation.getQuotationPrice());
        history.setQuotationTime(biddingQuotation.getQuotationTime());
        history.setQuotationTimer(biddingQuotation.getQuotationTimer());
        return super.save(history);
    }

    @Override
    @Transactional
    public boolean saveByQuoList(List<BizBiddingQuotation> quoList) {
        List<BizBiddingQuotationHistory> hisData = new ArrayList<>();
        for(BizBiddingQuotation biddingQuotation : quoList){
            BizBiddingQuotationHistory history = new BizBiddingQuotationHistory();
            if(BeanUtils.isNotEmpty(biddingQuotation.getQuotationRounds())) {
                history.setQuotationRounds(biddingQuotation.getQuotationRounds());
            }
            history.setAuctionBacthNum(biddingQuotation.getQuotationBacthNum());
            history.setNoticeId(biddingQuotation.getNoticeId());
            history.setNoticeType(biddingQuotation.getNoticeType());
            history.setQuotationNum(biddingQuotation.getQuotationNum());
            history.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
            history.setQuotationUserId(biddingQuotation.getQuotationUserId());
            history.setQuotationUserName(biddingQuotation.getQuotationUserName());
            history.setQuotationUserAccount(biddingQuotation.getQuotationUserAccount());
            if(BeanUtils.isNotEmpty(biddingQuotation.getQuotationUserPhone())) {
                history.setQuotationUserPhone(biddingQuotation.getQuotationUserPhone());
            }
            history.setQuotationCompanyId(biddingQuotation.getQuotationCompanyId());
            history.setQuotationCompanyCode(biddingQuotation.getQuotationCompanyCode());
            history.setQuotationCompanyName(biddingQuotation.getQuotationCompanyName());
            history.setQuotationMethod(biddingQuotation.getQuotationMethod());
            history.setIsTax(biddingQuotation.getIsTax());
            history.setTaxRate(biddingQuotation.getTaxRate());
            history.setQuotationPrice(biddingQuotation.getQuotationPrice());
            history.setQuotationAmount(biddingQuotation.getQuotationAmount());
            history.setQuotationTime(biddingQuotation.getQuotationTime());
            history.setQuotationTimer(biddingQuotation.getQuotationTimer());
            history.setMatNum(biddingQuotation.getMatNum());
            if(BeanUtils.isNotEmpty(biddingQuotation.getTenderExplain())){
                history.setTenderExplain(biddingQuotation.getTenderExplain());
            }
            hisData.add(history);
        }
        return super.saveBatch(hisData);
    }

    @Override
    public PageList<BizBiddingQuotationHistory> queryAllByPage(QueryFilter<BizBiddingQuotationHistory> queryFilter) {
        IPage<BizBiddingQuotationHistory> result = baseMapper.pageMatDetail(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void exportDataToExcel(QueryFilter<BizBiddingQuotationHistory> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "报价数据-导出结果";

        List<BizBiddingQuotationHistory> data = queryAllByPage(queryFilter).getRows();

        if(BeanUtils.isEmpty(data) || data.size()==0) {
            throw new RuntimeException("没有要导出的的数据！");
        }
        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams,BizBiddingQuotationHistory.class,data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

}
