package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.*;
import com.artfess.cgpt.bidding.model.*;
import com.artfess.cgpt.bidding.dao.BizBidEvaluationDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.bidding.vo.EvaVo;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.vo.MatApprovalDetailsEvaExportVO;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import freemarker.template.TemplateModel;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 评标记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizBidEvaluationManagerImpl extends BaseManagerImpl<BizBidEvaluationDao, BizBidEvaluation> implements BizBidEvaluationManager {

    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private MatApprovalDetailsManager matDetailsManager;
    @Autowired
    private ProjectApprovalDetailsManager paDetailManager;
    @Autowired
    private CalibrationDetailManager calibrationDetailManager;
    @Autowired
    private CalibrationManager calibrationManager;
    @Autowired
    private BidEvaluationDetailManager evaluationDetailManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private BiddingQuotationTemplateDetailDataManager quotationTemplateDetailDataManager;
    @Autowired
    private ProjectApprovalDetailsManager projectDetailsManager;


    @Override
    public PageList<BizBidEvaluation> queryAllByPage(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizBidEvaluation> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void saveOrUpdateEntity(BizBidEvaluation entity) {
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        super.saveOrUpdate(entity);
    }

    @Override
    @Transactional
    public void saveByEva(List<BizBidEvaluation> data) {
        for(BizBidEvaluation entity : data){
            entity.setOperateTime(LocalDateTime.now());
            entity.setOperateUserId(ContextUtil.getCurrentUserId());
            entity.setOperateUserName(ContextUtil.getCurrentUserName());
        }
        super.saveOrUpdateBatch(data);

        BizBidEvaluation bidEvaluation = data.get(0);
        if(bidEvaluation.getNoticeType()==1){
            LambdaUpdateWrapper<MatApproval> noticeUW = new LambdaUpdateWrapper<>();
            noticeUW.set(MatApproval::getBidStatus,6)
                    .eq(MatApproval::getId,bidEvaluation.getNoticeId())
                    .eq(MatApproval::getIsDele,"0");
            matApprovalManager.update(noticeUW);
        }else {
            LambdaUpdateWrapper<ProjectApproval> noticeUW = new LambdaUpdateWrapper<>();
            noticeUW.set(ProjectApproval::getBidStatus,6)
                    .eq(ProjectApproval::getId,bidEvaluation.getNoticeId())
                    .eq(ProjectApproval::getIsDele,"0");
            projectApprovalManager.update(noticeUW);
        }

    }

    @Override
    @Transactional
    public void saveByEva(BizBidEvaluation entity) {
        //清除该供应商历史评标数据
        LambdaQueryWrapper<BizBidEvaluation> hisQW = new LambdaQueryWrapper<>();
        hisQW.eq(BizBidEvaluation::getNoticeId,entity.getNoticeId())
                .eq(BizBidEvaluation::getQuotationOrgId,entity.getQuotationOrgId())
                .eq(BizBidEvaluation::getIsDele,"0")
                .last("limit 1");
        BizBidEvaluation evaHis = baseMapper.selectOne(hisQW);
        if(BeanUtils.isNotEmpty(evaHis)){
            //清除历史评标明细
//            LambdaQueryWrapper<BidEvaluationDetail> evaDetailHisQW = new LambdaQueryWrapper<>();
//            evaDetailHisQW.eq(BidEvaluationDetail::getBidEvaId,evaHis.getId());
//            evaluationDetailManager.remove(evaDetailHisQW);
//            super.remove(evaHis.getId());
        }

        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();

        MatApproval notice = matApprovalManager.getById(entity.getNoticeId());

        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());

        entity.setNoticeCode(notice.getProjectNumber());
        entity.setNoticeName(notice.getNoticeTitle());
        entity.setProcureOrgId(notice.getProcureOrgId());
        entity.setProcureOrgCode(notice.getProcureOrgCode());
        entity.setProcureOrgName(notice.getProcureOrgName());

        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(2);
        super.save(entity);

//        evaDetailList.forEach(s->s.setBidEvaId(entity.getId()));
        evaluationDetailManager.saveBatch(evaDetailList);

        if(entity.getNoticeType()==1){
            LambdaUpdateWrapper<MatApproval> noticeUW = new LambdaUpdateWrapper<>();
            noticeUW.set(MatApproval::getBidStatus,6)
                    .eq(MatApproval::getId,entity.getNoticeId())
                    .eq(MatApproval::getIsDele,"0");
            matApprovalManager.update(noticeUW);
        }else {
            LambdaUpdateWrapper<ProjectApproval> noticeUW = new LambdaUpdateWrapper<>();
            noticeUW.set(ProjectApproval::getBidStatus,6)
                    .eq(ProjectApproval::getId,entity.getNoticeId())
                    .eq(ProjectApproval::getIsDele,"0");
            projectApprovalManager.update(noticeUW);
        }

    }

    @Override
    @Transactional
    public void saveByEvaMat(BizBidEvaluation entity) {
        //清除该供应商历史评标数据
        LambdaQueryWrapper<BizBidEvaluation> hisQW = new LambdaQueryWrapper<>();
        hisQW.eq(BizBidEvaluation::getNoticeId,entity.getNoticeId())
                .eq(BizBidEvaluation::getNoticeType,entity.getNoticeType())
                .eq(BizBidEvaluation::getNoticeDetailedId,entity.getNoticeDetailedId())
                .eq(BizBidEvaluation::getQuotationOrgId,entity.getQuotationOrgId())
                .eq(BizBidEvaluation::getIsDele,"0")
                .last("limit 1");
        BizBidEvaluation evaHis = baseMapper.selectOne(hisQW);
        if(BeanUtils.isNotEmpty(evaHis)){
            //清除历史评标明细
            LambdaQueryWrapper<BidEvaluationDetail> evaDetailHisQW = new LambdaQueryWrapper<>();
//            evaDetailHisQW.eq(BidEvaluationDetail::getBidEvaId,evaHis.getId());
            evaluationDetailManager.remove(evaDetailHisQW);
            super.remove(evaHis.getId());
        }

        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();

        MatApproval notice = matApprovalManager.getById(entity.getNoticeId());

        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());

        entity.setNoticeCode(notice.getProjectNumber());
        entity.setNoticeName(notice.getNoticeTitle());
        entity.setProcureOrgId(notice.getProcureOrgId());
        entity.setProcureOrgCode(notice.getProcureOrgCode());
        entity.setProcureOrgName(notice.getProcureOrgName());

        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(1);
        super.save(entity);

//        evaDetailList.forEach(s->s.setBidEvaId(entity.getId()));
        evaluationDetailManager.saveBatch(evaDetailList);

        if(entity.getNoticeType()==1){
            //更新明细状态为已评标
            LambdaUpdateWrapper<MatApprovalDetails> noticeDetailUW = new LambdaUpdateWrapper<>();
            noticeDetailUW.set(MatApprovalDetails::getBidStatus,2)
                    .eq(MatApprovalDetails::getId,entity.getNoticeDetailedId())
                    .eq(MatApprovalDetails::getIsDele,"0");
            matDetailsManager.update(noticeDetailUW);

            //查询该项目是否有未评标的明细
            LambdaQueryWrapper<MatApprovalDetails> approvalDetailQW = new LambdaQueryWrapper<>();
            approvalDetailQW.eq(MatApprovalDetails::getBidStatus,1)
                    .eq(MatApprovalDetails::getNoticeId,entity.getNoticeId())
                    .eq(MatApprovalDetails::getIsDele,"0");
            //如果没有，更新项目状态为已评标
            if(matDetailsManager.count(approvalDetailQW)==0){
                notice.setBidStatus(6);
                matApprovalManager.updateById(notice);
            }
        }else {
            LambdaUpdateWrapper<ProjectApproval> noticeUW = new LambdaUpdateWrapper<>();
            noticeUW.set(ProjectApproval::getBidStatus,6)
                    .eq(ProjectApproval::getId,entity.getNoticeId())
                    .eq(ProjectApproval::getIsDele,"0");
            projectApprovalManager.update(noticeUW);
        }
    }

    //2024-04-26 11:13（未添加定标主表）
//    @Override
//    @Transactional
//    public void bidEvaLowest(BizBiddingQuotation biddingQuotation) {
//        LambdaQueryWrapper<CalibrationDetail> caQW = new LambdaQueryWrapper<>();
//        caQW.eq(CalibrationDetail::getNoticeId,biddingQuotation.getNoticeId())
//                .eq(CalibrationDetail::getNoticeDetailedId,biddingQuotation.getNoticeDetailedId());
//        calibrationDetailManager.remove(caQW);
//
//        BizBidEvaluation entity = new BizBidEvaluation();
//        CalibrationDetail caliDetail = new CalibrationDetail();
//
//        //查询这条明细是否有已评标的记录，如果有：更新记录
//        LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
//        bidEvaQW.eq(BizBidEvaluation::getNoticeId,biddingQuotation.getNoticeId())
//                .eq(BizBidEvaluation::getNoticeDetailedId,biddingQuotation.getNoticeDetailedId())
//                .eq(BizBidEvaluation::getIsDele,"0")
//                .last("limit 1");
//        BizBidEvaluation evaRecord = baseMapper.selectOne(bidEvaQW);
//        if(BeanUtils.isNotEmpty(evaRecord)) {
//            accessoryService.removeBySourceId(evaRecord.getId());
//            entity = evaRecord;
//        }
//
//        entity.setOperateTime(LocalDateTime.now());
//        entity.setOperateUserId(ContextUtil.getCurrentUserId());
//        entity.setOperateUserName(ContextUtil.getCurrentUserName());
//        entity.setNoticeId(biddingQuotation.getNoticeId());
//        List<Accessory> evaExplainAccessory = biddingQuotation.getEvaExplainAccessory();
//
//        //立项类型
//        String noticeType = biddingQuotation.getNoticeType();
//        entity.setNoticeType(Integer.valueOf(noticeType));
//        if(noticeType.equals("1")){
//            MatApproval notice = matApprovalManager.getById(biddingQuotation.getNoticeId());
//            entity.setNoticeCode(notice.getProjectNumber());
//            entity.setNoticeName(notice.getNoticeTitle());
//            entity.setProcureOrgId(notice.getProcureOrgId());
//            entity.setProcureOrgCode(notice.getProcureOrgCode());
//            entity.setProcureOrgName(notice.getProcureOrgName());
//            entity.setEvaluatingMethods(notice.getEvaluationMethod());
//            notice.setBidStatus(6);
//            matApprovalManager.updateById(notice);
//            caliDetail.setNoticeCode(notice.getProjectNumber());
//            caliDetail.setNoticeName(notice.getNoticeTitle());
//            caliDetail.setProcureOrgId(notice.getProcureOrgId());
//            caliDetail.setProcureOrgCode(notice.getProcureOrgCode());
//            caliDetail.setProcureOrgName(notice.getProcureOrgName());
//
//            MatApprovalDetails detail = maDetailsManager.getById(biddingQuotation.getNoticeDetailedId());
//            caliDetail.setMatId(detail.getMatId());
//            caliDetail.setMatPlatcode(detail.getMatPlatcode());
//            caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
//            caliDetail.setMatCode(detail.getMatCode());
//            caliDetail.setMatName(detail.getMatName());
//            caliDetail.setMatMaterial(detail.getMatMaterial());
//            caliDetail.setMatSpec(detail.getMatSpec());
//            caliDetail.setMatNum(detail.getMatNum());
//            caliDetail.setMatUnit(detail.getMatUnit());
//            caliDetail.setMatBrand(detail.getMatBrand());
//            caliDetail.setMatBaseExt(detail.getMatBaseExt());
//            caliDetail.setMatOtherExt(detail.getMatOtherExt());
//            caliDetail.setTaxRate(detail.getTaxRate());
//        }else {
//            ProjectApproval notice = projectApprovalManager.getById(biddingQuotation.getNoticeId());
//            entity.setNoticeCode(notice.getProjectNumber());
//            entity.setNoticeName(notice.getNoticeTitle());
//            entity.setProcureOrgId(notice.getProcureOrgId());
//            entity.setProcureOrgCode(notice.getProcureOrgCode());
//            entity.setProcureOrgName(notice.getProcureOrgName());
//            entity.setEvaluatingMethods(notice.getEvaluationMethod());
//            notice.setBidStatus(6);
//            projectApprovalManager.updateById(notice);
//            caliDetail.setNoticeCode(notice.getProjectNumber());
//            caliDetail.setNoticeName(notice.getNoticeTitle());
//            caliDetail.setProcureOrgId(notice.getProcureOrgId());
//            caliDetail.setProcureOrgCode(notice.getProcureOrgCode());
//            caliDetail.setProcureOrgName(notice.getProcureOrgName());
//
//            ProjectApprovalDetails detail = paDetailManager.getById(biddingQuotation.getNoticeDetailedId());
//            caliDetail.setMatId(detail.getMatId());
//            caliDetail.setMatPlatcode(detail.getMatPlatcode());
//            caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
//            caliDetail.setMatCode(detail.getMatCode());
//            caliDetail.setMatName(detail.getMatName());
//            caliDetail.setMatMaterial(detail.getMatMaterial());
//            caliDetail.setMatSpec(detail.getMatSpec());
//            caliDetail.setMatNum(detail.getMatNum());
//            caliDetail.setMatUnit(detail.getMatUnit());
//            caliDetail.setMatBrand(detail.getMatBrand());
//            caliDetail.setMatBaseExt(detail.getMatBaseExt());
//            caliDetail.setMatOtherExt(detail.getMatOtherExt());
//            caliDetail.setTaxRate(detail.getTaxRate());
//        }
//
//        entity.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
//        entity.setQuotationId(biddingQuotation.getId());
//        entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
//        entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
//        entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
//        entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
//        if(BeanUtils.isNotEmpty(biddingQuotation.getEvaExplain())){
//            entity.setEvaExplain(biddingQuotation.getEvaExplain());
//        }
//
//        super.save(entity);
//        if(BeanUtils.isNotEmpty(evaExplainAccessory) && evaExplainAccessory.size()>0){
//            BizBidEvaluation finalEntity = entity;
//            evaExplainAccessory.stream().forEach(s->{
//                s.setSourceId(finalEntity.getId());
//            });
//            accessoryService.saveBatch(evaExplainAccessory);
//        }
//
//        //保存定标明细记录
//        caliDetail.setNoticeId(biddingQuotation.getNoticeId());
//        caliDetail.setVendorId(biddingQuotation.getQuotationCompanyId());
//        caliDetail.setVendorCode(biddingQuotation.getQuotationCompanyCode());
//        caliDetail.setVendorName(biddingQuotation.getQuotationCompanyName());
//        caliDetail.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
//        caliDetail.setIsTax(biddingQuotation.getIsTax());
//        caliDetail.setStatus(1);
//        caliDetail.setWinBidPrice(biddingQuotation.getQuotationPrice());
//        calibrationDetailManager.save(caliDetail);
//    }

    @Override
    @Transactional
    public void bidEvaLowest(BizBiddingQuotation biddingQuotation) {
        LambdaQueryWrapper<Calibration> caQW = new LambdaQueryWrapper<>();
        caQW.eq(Calibration::getNoticeId,biddingQuotation.getNoticeId())
                .eq(Calibration::getNoticeType,biddingQuotation.getNoticeType())
                .eq(Calibration::getIsDele,"0");
        calibrationManager.remove(caQW);

        LambdaQueryWrapper<CalibrationDetail> caDetailQW = new LambdaQueryWrapper<>();
        caDetailQW.eq(CalibrationDetail::getNoticeId,biddingQuotation.getNoticeId())
                .eq(CalibrationDetail::getNoticeDetailedId,biddingQuotation.getNoticeDetailedId());
        calibrationDetailManager.remove(caDetailQW);

        BizBidEvaluation entity = new BizBidEvaluation();
        Calibration calibration = new Calibration();
        CalibrationDetail caliDetail = new CalibrationDetail();

        //查询这条明细是否有已评标的记录，如果有：更新记录
        LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
        bidEvaQW.eq(BizBidEvaluation::getNoticeId,biddingQuotation.getNoticeId())
                .eq(BizBidEvaluation::getNoticeDetailedId,biddingQuotation.getNoticeDetailedId())
                .eq(BizBidEvaluation::getIsDele,"0")
                .last("limit 1");
        BizBidEvaluation evaRecord = baseMapper.selectOne(bidEvaQW);
        if(BeanUtils.isNotEmpty(evaRecord)) {
            accessoryService.removeBySourceId(evaRecord.getId());
            entity = evaRecord;
        }

        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        entity.setNoticeId(biddingQuotation.getNoticeId());
        List<Accessory> evaExplainAccessory = biddingQuotation.getEvaExplainAccessory();

        //立项类型
        String noticeType = biddingQuotation.getNoticeType();
        entity.setNoticeType(Integer.valueOf(noticeType));
        if(noticeType.equals("1")){
            MatApproval notice = matApprovalManager.getById(biddingQuotation.getNoticeId());
            entity.setNoticeCode(notice.getProjectNumber());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            notice.setBidStatus(6);
            matApprovalManager.updateById(notice);
            calibration.setNoticeCode(notice.getProjectNumber());
            calibration.setNoticeName(notice.getNoticeTitle());

            caliDetail.setNoticeCode(notice.getProjectNumber());
            caliDetail.setNoticeName(notice.getNoticeTitle());
            caliDetail.setProcureOrgId(notice.getProcureOrgId());
            caliDetail.setProcureOrgCode(notice.getProcureOrgCode());
            caliDetail.setProcureOrgName(notice.getProcureOrgName());

            MatApprovalDetails detail = matDetailsManager.getById(biddingQuotation.getNoticeDetailedId());
            caliDetail.setMatId(detail.getMatId());
            caliDetail.setMatPlatcode(detail.getMatPlatcode());
            caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
            caliDetail.setMatCode(detail.getMatCode());
            caliDetail.setMatName(detail.getMatName());
            caliDetail.setMatMaterial(detail.getMatMaterial());
            caliDetail.setMatSpec(detail.getMatSpec());
            caliDetail.setMatNum(detail.getMatNum());
            caliDetail.setMatUnit(detail.getMatUnit());
            caliDetail.setMatBrand(detail.getMatBrand());
            caliDetail.setMatBaseExt(detail.getMatBaseExt());
            caliDetail.setMatOtherExt(detail.getMatOtherExt());
            caliDetail.setTaxRate(detail.getTaxRate());
        }else {
            ProjectApproval notice = projectApprovalManager.getById(biddingQuotation.getNoticeId());
            entity.setNoticeCode(notice.getNoticeCode());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            notice.setBidStatus(6);
            projectApprovalManager.updateById(notice);
            caliDetail.setNoticeCode(notice.getNoticeCode());
            caliDetail.setNoticeName(notice.getNoticeTitle());
            caliDetail.setProcureOrgId(notice.getProcureOrgId());
            caliDetail.setProcureOrgCode(notice.getProcureOrgCode());
            caliDetail.setProcureOrgName(notice.getProcureOrgName());

            ProjectApprovalDetails detail = paDetailManager.getById(biddingQuotation.getNoticeDetailedId());
            caliDetail.setMatId(detail.getMatId());
            caliDetail.setMatPlatcode(detail.getMatPlatcode());
            caliDetail.setMatCategoryCode(detail.getMatCategoryCode());
            caliDetail.setMatCode(detail.getMatCode());
            caliDetail.setMatName(detail.getMatName());
            caliDetail.setMatMaterial(detail.getMatMaterial());
            caliDetail.setMatSpec(detail.getMatSpec());
            caliDetail.setMatNum(detail.getMatNum());
            caliDetail.setMatUnit(detail.getMatUnit());
            caliDetail.setMatBrand(detail.getMatBrand());
            caliDetail.setMatBaseExt(detail.getMatBaseExt());
            caliDetail.setMatOtherExt(detail.getMatOtherExt());
            caliDetail.setTaxRate(detail.getTaxRate());
        }

        entity.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
        entity.setQuotationId(biddingQuotation.getId());
        entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
        entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
        entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
        entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
        if(BeanUtils.isNotEmpty(biddingQuotation.getEvaExplain())){
            entity.setEvaExplain(biddingQuotation.getEvaExplain());
        }

        super.save(entity);
        if(BeanUtils.isNotEmpty(evaExplainAccessory) && evaExplainAccessory.size()>0){
            BizBidEvaluation finalEntity = entity;
            evaExplainAccessory.stream().forEach(s->{
                s.setSourceId(finalEntity.getId());
            });
            accessoryService.saveBatch(evaExplainAccessory);
        }

        //保存定标记录
        calibration.setNoticeId(biddingQuotation.getNoticeId());
        calibration.setNoticeType(Integer.valueOf(biddingQuotation.getNoticeType()));
        calibration.setVendorId(biddingQuotation.getQuotationCompanyId());
        calibration.setVendorCode(biddingQuotation.getQuotationCompanyCode());
        calibration.setVendorName(biddingQuotation.getQuotationCompanyName());
        calibration.setWinBidPrice(biddingQuotation.getQuotationPrice());
        if(BeanUtils.isNotEmpty(biddingQuotation.getRank())) {
            calibration.setRank(biddingQuotation.getRank());
        }
        calibrationManager.save(calibration);

        //保存定标明细记录
        caliDetail.setCalibrationId(calibration.getId());
        caliDetail.setNoticeId(biddingQuotation.getNoticeId());
        caliDetail.setVendorId(biddingQuotation.getQuotationCompanyId());
        caliDetail.setVendorCode(biddingQuotation.getQuotationCompanyCode());
        caliDetail.setVendorName(biddingQuotation.getQuotationCompanyName());
        caliDetail.setNoticeDetailedId(biddingQuotation.getNoticeDetailedId());
        caliDetail.setIsTax(biddingQuotation.getIsTax());
        caliDetail.setStatus(1);
        caliDetail.setWinBidPrice(biddingQuotation.getQuotationPrice());
        calibrationDetailManager.save(caliDetail);
    }

    @Override
    @Transactional
    public void bidEvaLowest(EvaVo evaVo) {
        //删除该明细已评标的记录
        LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
        bidEvaQW.eq(BizBidEvaluation::getNoticeId,evaVo.getNoticeId())
                .eq(BizBidEvaluation::getNoticeType,evaVo.getNoticeType())
                .eq(BizBidEvaluation::getNoticeDetailedId,evaVo.getNoticeDetailedId());
        super.remove(bidEvaQW);

        List<BizBiddingQuotation> quotationList = evaVo.getQuotationList();

        MatApproval notice = matApprovalManager.getById(evaVo.getNoticeId());
        Integer bidOrgNum = notice.getAllocationOfShares();
        //1.根据份额分配数量判断中标单位
        if(bidOrgNum!=quotationList.size()){
            throw new BaseException("评标供应商数量不一致，请选择"+bidOrgNum+"家供应商");
        }

        //如果不止一家中标，根据价格排序（由低到高）
        if(bidOrgNum>1){
            quotationList.sort(new Comparator<BizBiddingQuotation>() {
                @Override
                public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                    if(o1.getQuotationPrice().compareTo(o2.getQuotationPrice())==0){
                        return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                    }else {
                        return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                    }
                }
            });
        }

        MatApprovalDetails noticeDetail = matDetailsManager.getById(evaVo.getNoticeDetailedId());

        int i = 1;
        for(BizBiddingQuotation biddingQuotation : quotationList){
            BizBidEvaluation entity = new BizBidEvaluation();

            entity.setOperateTime(LocalDateTime.now());
            entity.setOperateUserId(ContextUtil.getCurrentUserId());
            entity.setOperateUserName(ContextUtil.getCurrentUserName());
            entity.setNoticeId(evaVo.getNoticeId());
            List<Accessory> evaExplainAccessory = biddingQuotation.getEvaExplainAccessory();

            //立项类型
//            String noticeType = biddingQuotation.getNoticeType();
            entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
            entity.setNoticeCode(notice.getProjectNumber());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            entity.setEvaluationMode(1);

            entity.setNoticeDetailedId(evaVo.getNoticeDetailedId());
            entity.setQuotationId(biddingQuotation.getId());
            entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
            entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
            entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
            entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
            entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
            if(BeanUtils.isNotEmpty(biddingQuotation.getEvaExplain())){
                entity.setEvaExplain(biddingQuotation.getEvaExplain());
            }

            if(bidOrgNum==1){
                //如果只有一家供应商中标，供货分配额为100%
                entity.setShareAllocationRate(new BigDecimal("100"));
                entity.setShareAllocationNum(noticeDetail.getMatNum());
            }else {
                //如果有多家，根据分配率进行分配
                if(i==1){
                    entity.setShareAllocationRate(notice.getAllocationRate1());
                }else if(i==2){
                    entity.setShareAllocationRate(notice.getAllocationRate2());
                }else if(i==3){
                    entity.setShareAllocationRate(notice.getAllocationRate3());
                }else if(i==4){
                    entity.setShareAllocationRate(notice.getAllocationRate4());
                }else {
                    entity.setShareAllocationRate(notice.getAllocationRate5());
                }
                entity.setShareAllocationNum(entity.getShareAllocationRate().divide(new BigDecimal("100")).multiply(noticeDetail.getMatNum()));
            }
//            entity.setQuotationAmount(entity.getQuotationPrice().multiply(entity.getShareAllocationNum()));
            super.save(entity);
            String entityId = entity.getId();
            if(BeanUtils.isNotEmpty(evaExplainAccessory) && evaExplainAccessory.size()>0){
                evaExplainAccessory.stream().forEach(s->{
                    s.setSourceId(entityId);
                });
                accessoryService.saveBatch(evaExplainAccessory);
            }

            i++;
        }

        //更新明细状态为已评标
        noticeDetail.setBidStatus(2);
        matDetailsManager.updateById(noticeDetail);

        //查询该项目是否有未评标的明细
        LambdaQueryWrapper<MatApprovalDetails> approvalDetailQW = new LambdaQueryWrapper<>();
        approvalDetailQW.eq(MatApprovalDetails::getBidStatus,1)
                .eq(MatApprovalDetails::getNoticeId,evaVo.getNoticeId())
                .eq(MatApprovalDetails::getIsDele,"0");
        //如果没有，更新项目状态为已评标
        if(matDetailsManager.count(approvalDetailQW)==0){
            notice.setBidStatus(6);
            matApprovalManager.updateById(notice);
        }

    }

    @Override
    @Transactional
    public void choiceBidEvaLowestPro(EvaVo evaVo) {
        //删除该明细已评标的记录
        LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
        bidEvaQW.eq(BizBidEvaluation::getNoticeId,evaVo.getNoticeId())
                .eq(BizBidEvaluation::getNoticeType,evaVo.getNoticeType())
                .eq(BizBidEvaluation::getNoticeDetailedId,evaVo.getNoticeDetailedId());
        super.remove(bidEvaQW);

        List<BizBiddingQuotation> quotationList = evaVo.getQuotationList();

        ProjectApproval notice = projectApprovalManager.getById(evaVo.getNoticeId());
        Integer bidOrgNum = 1;

        //1.根据份额分配数量判断中标单位
        if(bidOrgNum!=quotationList.size()){
            throw new BaseException("评标供应商数量不一致，请选择"+bidOrgNum+"家供应商");
        }

        //如果不止一家中标，根据价格排序（由低到高）
        if(bidOrgNum>1){
            quotationList.sort(new Comparator<BizBiddingQuotation>() {
                @Override
                public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                    if(o1.getQuotationPrice().compareTo(o2.getQuotationPrice())==0){
                        return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                    }else {
                        return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                    }
                }
            });
        }

        ProjectApprovalDetails noticeDetail = projectDetailsManager.getById(evaVo.getNoticeDetailedId());

        int i = 1;
        for(BizBiddingQuotation biddingQuotation : quotationList){
            BizBidEvaluation entity = new BizBidEvaluation();

            entity.setOperateTime(LocalDateTime.now());
            entity.setOperateUserId(ContextUtil.getCurrentUserId());
            entity.setOperateUserName(ContextUtil.getCurrentUserName());
            entity.setNoticeId(evaVo.getNoticeId());
            List<Accessory> evaExplainAccessory = biddingQuotation.getEvaExplainAccessory();

            //立项类型
//            String noticeType = biddingQuotation.getNoticeType();
            entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
            entity.setNoticeCode(notice.getNoticeCode());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
            entity.setEvaluatingMethods(notice.getEvaluationMethod());
            entity.setEvaluationMode(1);

            entity.setNoticeDetailedId(evaVo.getNoticeDetailedId());
            entity.setQuotationId(biddingQuotation.getId());
            entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
            entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
            entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
            entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
            entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
            if(BeanUtils.isNotEmpty(biddingQuotation.getEvaExplain())){
                entity.setEvaExplain(biddingQuotation.getEvaExplain());
            }

            if(bidOrgNum==1){
                //如果只有一家供应商中标，供货分配额为100%
                entity.setShareAllocationRate(new BigDecimal("100"));
                entity.setShareAllocationNum(noticeDetail.getMatNum());
            }else {
                //如果有多家，根据分配率进行分配
                entity.setShareAllocationNum(entity.getShareAllocationRate().divide(new BigDecimal("100")).multiply(noticeDetail.getMatNum()));
            }
//            entity.setQuotationAmount(entity.getQuotationPrice().multiply(entity.getShareAllocationNum()));
            super.save(entity);
            String entityId = entity.getId();
            if(BeanUtils.isNotEmpty(evaExplainAccessory) && evaExplainAccessory.size()>0){
                evaExplainAccessory.stream().forEach(s->{
                    s.setSourceId(entityId);
                });
                accessoryService.saveBatch(evaExplainAccessory);
            }

            i++;
        }

        //更新明细状态为已评标
        noticeDetail.setBidStatus(2);
        projectDetailsManager.updateById(noticeDetail);

        //查询该项目是否有未评标的明细
        LambdaQueryWrapper<ProjectApprovalDetails> approvalDetailQW = new LambdaQueryWrapper<>();
        approvalDetailQW.eq(ProjectApprovalDetails::getBidStatus,1)
                .eq(ProjectApprovalDetails::getNoticeId,evaVo.getNoticeId())
                .eq(ProjectApprovalDetails::getIsDele,"0");
        //如果没有，更新项目状态为已评标
        if(projectDetailsManager.count(approvalDetailQW)==0){
            notice.setBidStatus(6);
            projectApprovalManager.updateById(notice);
        }

    }



    @Override
    @Transactional
    public void bidEvaLowestAuto(EvaVo evaVo) {
        //删除该立项已评标的记录
        LambdaQueryWrapper<BizBidEvaluation> bidEvaQW = new LambdaQueryWrapper<>();
        bidEvaQW.eq(BizBidEvaluation::getNoticeId,evaVo.getNoticeId())
                .eq(BizBidEvaluation::getNoticeType,evaVo.getNoticeType());
        super.remove(bidEvaQW);

        Integer bidOrgNum = 1;

        List<BizBidEvaluation> evaSaveData = new ArrayList<>();

        if(evaVo.getNoticeType().equals("2")){
            //项目
            ProjectApproval notice = projectApprovalManager.getById(evaVo.getNoticeId());
//            bidOrgNum = notice.getAllocationOfShares();

            LambdaQueryWrapper<ProjectApprovalDetails> noticeDetailQW = new LambdaQueryWrapper<>();
            noticeDetailQW.eq(ProjectApprovalDetails::getNoticeId,notice.getId())
                    .eq(ProjectApprovalDetails::getIsDele,"0");
            List<ProjectApprovalDetails> noticeDetailList= projectDetailsManager.list(noticeDetailQW);

            LambdaQueryWrapper<BizBiddingQuotation> quoQW = new LambdaQueryWrapper<>();
            quoQW.eq(BizBiddingQuotation::getNoticeId,notice.getId())
                    .eq(BizBiddingQuotation::getNoticeType,evaVo.getNoticeType())
                    .eq(BizBiddingQuotation::getQuotationRounds,notice.getQuotationRoundsNum())
                    .gt(BizBiddingQuotation::getQuotationPrice,BigDecimal.ZERO);
            List<BizBiddingQuotation> quoList = quotationManager.list(quoQW);

            for(ProjectApprovalDetails noticeDetail : noticeDetailList){
                List<BizBiddingQuotation> quotationList = quoList.stream().filter(s -> s.getNoticeDetailedId().equals(noticeDetail.getId())).sorted(new Comparator<BizBiddingQuotation>() {
                    @Override
                    public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                        if (o1.getQuotationPrice().compareTo(o2.getQuotationPrice()) == 0) {
                            return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                        }
                        return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                    }
                }).limit(bidOrgNum).collect(Collectors.toList());

                for(BizBiddingQuotation biddingQuotation : quotationList){
                    BizBidEvaluation entity = new BizBidEvaluation();
                    entity.setOperateTime(LocalDateTime.now());
//                entity.setOperateUserId(ContextUtil.getCurrentUserId());
//                entity.setOperateUserName(ContextUtil.getCurrentUserName());
                    entity.setNoticeId(evaVo.getNoticeId());

                    //立项类型
                    entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
                    entity.setNoticeCode(notice.getNoticeCode());
                    entity.setNoticeName(notice.getNoticeTitle());
                    entity.setProcureOrgId(notice.getProcureOrgId());
                    entity.setProcureOrgCode(notice.getProcureOrgCode());
                    entity.setProcureOrgName(notice.getProcureOrgName());
                    entity.setEvaluatingMethods(notice.getEvaluationMethod());
                    entity.setEvaluationMode(1);

                    entity.setNoticeDetailedId(noticeDetail.getId());
                    entity.setQuotationId(biddingQuotation.getId());
                    entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
                    entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
                    entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
                    entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
                    entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
                    if(BeanUtils.isNotEmpty(biddingQuotation.getEvaExplain())){
                        entity.setEvaExplain(biddingQuotation.getEvaExplain());
                    }

                    //如果只有一家供应商中标，供货分配额为100%
                    entity.setShareAllocationRate(new BigDecimal("100"));
                    entity.setShareAllocationNum(noticeDetail.getMatNum());

                    evaSaveData.add(entity);
                }
            }

            //更新明细状态为已评标
            LambdaUpdateWrapper<ProjectApprovalDetails> approvalDetailUW = new LambdaUpdateWrapper<>();
            approvalDetailUW.set(ProjectApprovalDetails::getBidStatus,2)
                    .eq(ProjectApprovalDetails::getNoticeId,evaVo.getNoticeId())
                    .eq(ProjectApprovalDetails::getIsDele,"0");
            projectDetailsManager.update(approvalDetailUW);
            //更新项目状态为已评标
            notice.setBidStatus(6);
            projectApprovalManager.updateById(notice);

        }else {
            //物资
            MatApproval notice = matApprovalManager.getById(evaVo.getNoticeId());
            bidOrgNum = notice.getAllocationOfShares();

            LambdaQueryWrapper<MatApprovalDetails> noticeDetailQW = new LambdaQueryWrapper<>();
            noticeDetailQW.eq(MatApprovalDetails::getNoticeId,notice.getId())
                    .eq(MatApprovalDetails::getIsDele,"0");
            List<MatApprovalDetails> noticeDetailList = matDetailsManager.list(noticeDetailQW);

            LambdaQueryWrapper<BizBiddingQuotation> quoQW = new LambdaQueryWrapper<>();
            quoQW.eq(BizBiddingQuotation::getNoticeId,notice.getId())
                    .eq(BizBiddingQuotation::getNoticeType,evaVo.getNoticeType())
                    .eq(BizBiddingQuotation::getQuotationRounds,notice.getQuotationRoundsNum())
                    .gt(BizBiddingQuotation::getQuotationPrice,BigDecimal.ZERO);
            List<BizBiddingQuotation> quoList = quotationManager.list(quoQW);

            for(MatApprovalDetails noticeDetail : noticeDetailList){
                List<BizBiddingQuotation> quotationList = quoList.stream().filter(s -> s.getNoticeDetailedId().equals(noticeDetail.getId())).sorted(new Comparator<BizBiddingQuotation>() {
                    @Override
                    public int compare(BizBiddingQuotation o1, BizBiddingQuotation o2) {
                        if (o1.getQuotationPrice().compareTo(o2.getQuotationPrice()) == 0) {
                            return o1.getQuotationTime().compareTo(o2.getQuotationTime());
                        }
                        return o1.getQuotationPrice().compareTo(o2.getQuotationPrice());
                    }
                }).limit(bidOrgNum).collect(Collectors.toList());

                for(BizBiddingQuotation biddingQuotation : quotationList){
                    int i = 1;
                    BizBidEvaluation entity = new BizBidEvaluation();
                    entity.setOperateTime(LocalDateTime.now());
//                entity.setOperateUserId(ContextUtil.getCurrentUserId());
//                entity.setOperateUserName(ContextUtil.getCurrentUserName());
                    entity.setNoticeId(evaVo.getNoticeId());

                    //立项类型
                    entity.setNoticeType(Integer.valueOf(evaVo.getNoticeType()));
                    entity.setNoticeCode(notice.getProjectNumber());
                    entity.setNoticeName(notice.getNoticeTitle());
                    entity.setProcureOrgId(notice.getProcureOrgId());
                    entity.setProcureOrgCode(notice.getProcureOrgCode());
                    entity.setProcureOrgName(notice.getProcureOrgName());
                    entity.setEvaluatingMethods(notice.getEvaluationMethod());
                    entity.setEvaluationMode(1);

                    entity.setNoticeDetailedId(noticeDetail.getId());
                    entity.setQuotationId(biddingQuotation.getId());
                    entity.setQuotationOrgId(biddingQuotation.getQuotationCompanyId());
                    entity.setQuotationOrgCode(biddingQuotation.getQuotationCompanyCode());
                    entity.setQuotationOrgName(biddingQuotation.getQuotationCompanyName());
                    entity.setQuotationPrice(biddingQuotation.getQuotationPrice());
                    entity.setQuotationAmount(biddingQuotation.getQuotationAmount());
                    if(BeanUtils.isNotEmpty(biddingQuotation.getEvaExplain())){
                        entity.setEvaExplain(biddingQuotation.getEvaExplain());
                    }

                    if(quotationList.size()==1){
                        //如果只有一家供应商中标，供货分配额为100%
                        entity.setShareAllocationRate(new BigDecimal("100"));
                        entity.setShareAllocationNum(noticeDetail.getMatNum());
                    }else {
                        //如果有多家，根据分配率进行分配
                        if(i==1){
                            entity.setShareAllocationRate(notice.getAllocationRate1());
                        }else if(i==2){
                            entity.setShareAllocationRate(notice.getAllocationRate2());
                        }else if(i==3){
                            entity.setShareAllocationRate(notice.getAllocationRate3());
                        }else if(i==4){
                            entity.setShareAllocationRate(notice.getAllocationRate4());
                        }else {
                            entity.setShareAllocationRate(notice.getAllocationRate5());
                        }
                        entity.setShareAllocationNum(entity.getShareAllocationRate().divide(new BigDecimal("100")).multiply(noticeDetail.getMatNum()));
                    }
//            entity.setQuotationAmount(entity.getQuotationPrice().multiply(entity.getShareAllocationNum()));
                    evaSaveData.add(entity);
                    i++;
                }
            }

            //更新明细状态为已评标
            LambdaUpdateWrapper<MatApprovalDetails> approvalDetailUW = new LambdaUpdateWrapper<>();
            approvalDetailUW.set(MatApprovalDetails::getBidStatus,2)
                    .eq(MatApprovalDetails::getNoticeId,evaVo.getNoticeId())
                    .eq(MatApprovalDetails::getIsDele,"0");
            matDetailsManager.update(approvalDetailUW);
            //更新项目状态为已评标
            notice.setBidStatus(6);
            matApprovalManager.updateById(notice);

        }

        if(evaSaveData.size()>0){
            super.saveBatch(evaSaveData);
        }

    }


    @Override
    public BigDecimal getTotalScore(String quoOrgId, String noticeId) {
        BigDecimal result = baseMapper.getTotalScore(quoOrgId, noticeId);
        return result;
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailComprehensive(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        String noticeId = null;
        String noticeType = "1";
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equals("a.NOTICE_ID_")){
                    noticeId = String.valueOf(qf.getValue());
                }
                if(qf.getProperty().equals("a.NOTICE_TYPE_")){
                    noticeType = String.valueOf(qf.getValue());
                }
            }
        }

        List<BizBidEvaluation> records = new ArrayList<>();

        HashMap<String, BigDecimal> shareMap = new HashMap<>();

        if(noticeType.equals("2")){
            //项目
            records = baseMapper.queryNoticeDetailAllByPagePro(new Page<>(0, -1, false),
                    convert2Wrapper(queryFilter, currentModelClass())).getRecords();
            //2.查询评分表，根据物料分组，得分排序，取分配数量
            Map<String, List<BizBidEvaluation>> collect = records.stream().collect(Collectors.groupingBy(BizBidEvaluation::getNoticeDetailedId));

            collect.forEach((k,v)->{
                List<BizBidEvaluation> data = v.stream().sorted(new Comparator<BizBidEvaluation>() {
                    @Override
                    public int compare(BizBidEvaluation o1, BizBidEvaluation o2) {
                        return o2.getScore().compareTo(o1.getScore());
                    }
                }).collect(Collectors.toList());
                shareMap.put(data.get(0).getId(),new BigDecimal("100"));
            });

        }else {
            //物资

            //1.查询立项份额分配数量
            MatApproval notice = matApprovalManager.getById(noticeId);
            records = baseMapper.queryNoticeDetailAllByPage(new Page<>(0, -1, false),
                    convert2Wrapper(queryFilter, currentModelClass())).getRecords();

            //2.查询评分表，根据物料分组，得分排序，取分配数量
            Map<String, List<BizBidEvaluation>> collect = records.stream().collect(Collectors.groupingBy(BizBidEvaluation::getNoticeDetailedId));

            collect.forEach((k,v)->{
                List<BizBidEvaluation> data = v.stream().sorted(new Comparator<BizBidEvaluation>() {
                    @Override
                    public int compare(BizBidEvaluation o1, BizBidEvaluation o2) {
                        return o2.getScore().compareTo(o1.getScore());
                    }
                }).collect(Collectors.toList());

                for(int i = 0;i<notice.getAllocationOfShares();i++){
                    BigDecimal shareRate = new BigDecimal("100");
                    if(notice.getAllocationOfShares()>1){
                        if(i==0){
                            shareRate = notice.getAllocationRate1();
                        }else if(i==1){
                            shareRate = notice.getAllocationRate2();
                        }else if(i==2){
                            shareRate = notice.getAllocationRate3();
                        }else if(i==3){
                            shareRate = notice.getAllocationRate4();
                        }else if(i==4){
                            shareRate = notice.getAllocationRate5();
                        }
                    }
                    shareMap.put(data.get(i).getId(),shareRate);
                }
            });
        }

        queryFilter.addFilter("a.ID_",new ArrayList<>(shareMap.keySet()), QueryOP.IN);
        IPage<BizBidEvaluation> result = null;
        if(noticeType.equals("2")){
            //项目
            result = baseMapper.queryNoticeDetailAllByPagePro(convert2IPage(queryFilter.getPageBean()),
                    convert2Wrapper(queryFilter, currentModelClass()));
        }else {
            //物资
            result = baseMapper.queryNoticeDetailAllByPage(convert2IPage(queryFilter.getPageBean()),
                    convert2Wrapper(queryFilter, currentModelClass()));
        }

        List<BizBidEvaluation> records1 = result.getRecords();
        for(BizBidEvaluation temp : records1){
            temp.setShareAllocationRate(shareMap.get(temp.getId()));
            temp.setShareAllocationNum(temp.getShareAllocationRate().divide(new BigDecimal("100")).multiply(temp.getMatNum()).setScale(4, RoundingMode.HALF_UP));
        }
        return new PageList<>(result);
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailComprehensivePro(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        String noticeId = null;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equals("a.NOTICE_ID_")){
                    noticeId = String.valueOf(qf.getValue());
                    break;
                }
            }
        }
        //1.查询立项份额分配数量
        ProjectApproval notice = projectApprovalManager.getById(noticeId);
        List<BizBidEvaluation> records = baseMapper.queryNoticeDetailAllByPagePro(new Page<>(0, -1, false),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        //2.查询评分表，根据物料分组，得分排序，取分配数量
        Map<String, List<BizBidEvaluation>> collect = records.stream().collect(Collectors.groupingBy(BizBidEvaluation::getNoticeDetailedId));

        List<String> evaIds = new ArrayList<>();
        HashMap<String, BigDecimal> shareMap = new HashMap<>();
        collect.forEach((k,v)->{
            List<BizBidEvaluation> data = v.stream().sorted(new Comparator<BizBidEvaluation>() {
                @Override
                public int compare(BizBidEvaluation o1, BizBidEvaluation o2) {
                    return o2.getScore().compareTo(o1.getScore());
                }
            }).collect(Collectors.toList());

            evaIds.add(data.get(0).getId());

//            for(int i = 0;i<notice.getAllocationOfShares();i++){
//                BigDecimal shareRate = new BigDecimal("100");
//                if(notice.getAllocationOfShares()>1){
//                    if(i==0){
//                        shareRate = notice.getAllocationRate1();
//                    }else if(i==1){
//                        shareRate = notice.getAllocationRate2();
//                    }else if(i==2){
//                        shareRate = notice.getAllocationRate3();
//                    }else if(i==3){
//                        shareRate = notice.getAllocationRate4();
//                    }else if(i==4){
//                        shareRate = notice.getAllocationRate5();
//                    }
//                }
//                shareMap.put(data.get(i).getId(),shareRate);
//            }
        });


        queryFilter.addFilter("a.ID_",evaIds, QueryOP.IN);
        IPage<BizBidEvaluation> result = baseMapper.queryNoticeDetailAllByPagePro(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        List<BizBidEvaluation> records1 = result.getRecords();
        for(BizBidEvaluation temp : records1){
            temp.setShareAllocationRate(new BigDecimal("100"));
            temp.setShareAllocationNum(temp.getShareAllocationRate().divide(new BigDecimal("100")).multiply(temp.getMatNum()).setScale(4, RoundingMode.HALF_UP));
        }
        return new PageList<>(result);
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailById(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizBidEvaluation> result = baseMapper.queryNoticeDetailAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<BizBidEvaluation> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBidEvaluation eva : records){
                //查询报价模版信息
                LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,eva.getQuotationId());
                List<BiddingQuotationTemplateDetailData> templateDataList = quotationTemplateDetailDataManager.list(templateDataQW);
                eva.setQuotationTemplateDetailDataList(templateDataList);
            }
        }

        return new PageList<>(result);
    }

    @Override
    public void exportCalibraDetail(QueryFilter<BizBidEvaluation> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "评标明细-导出结果";

        Boolean noticeIdFilter = false;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            List<QueryField> collect = querys.stream().filter(s -> s.getProperty().equals("a.NOTICE_ID_")).collect(Collectors.toList());
            if(BeanUtils.isEmpty(collect) || collect.size()<=0){
                noticeIdFilter = true;
            }
        }else {
            noticeIdFilter = true;
        }

        if(noticeIdFilter){
            //查询当前公司查看的公告列表
            QueryFilter<MatApproval> noticeQF = QueryFilter.build();
            noticeQF.addFilter("BID_STATUS_","6",QueryOP.EQUAL);
            noticeQF.setPageBean(new PageBean(0,-1,false));
            List<MatApproval> rows = matApprovalManager.bidEvaAgencyData(noticeQF).getRows();
            if(BeanUtils.isEmpty(rows) || rows.size()<=0){
                throw new RuntimeException("没有要导出的的数据！");
            }

            List<String> collect1 = rows.stream().map(s -> s.getId()).collect(Collectors.toList());
            queryFilter.addFilter("a.NOTICE_ID_",collect1,QueryOP.IN);
        }

        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        List<BizBidEvaluation> data = baseMapper.queryNoticeDetailAllByPage(convert2IPage(new PageBean(0, -1, false)),
                convert2Wrapper(queryFilter, currentModelClass())).getRecords();

        if(BeanUtils.isEmpty(data) || data.size()==0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams,BizBidEvaluation.class,data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    public PageList<BizBidEvaluation> getCalibraDetailByIdPro(QueryFilter<BizBidEvaluation> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizBidEvaluation> result = baseMapper.queryNoticeDetailAllByPagePro(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<BizBidEvaluation> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            for(BizBidEvaluation eva : records){
                //查询报价模版信息
                LambdaQueryWrapper<BiddingQuotationTemplateDetailData> templateDataQW = new LambdaQueryWrapper<>();
                templateDataQW.eq(BiddingQuotationTemplateDetailData::getQuotationId,eva.getQuotationId());
                List<BiddingQuotationTemplateDetailData> templateDataList = quotationTemplateDetailDataManager.list(templateDataQW);
                eva.setQuotationTemplateDetailDataList(templateDataList);
            }
        }

        return new PageList<>(result);
    }

    @Override
    public List<BizBidEvaluation> getCalibraDetailMaxScoreById(String noticeId) {
        MatApproval notice = matApprovalManager.getById(noticeId);
        LambdaQueryWrapper<BizBidEvaluation> resultQW = new LambdaQueryWrapper<>();
        resultQW.eq(BizBidEvaluation::getNoticeId,noticeId)
                .eq(BizBidEvaluation::getIsDele,"0")
                .orderByDesc(BizBidEvaluation::getScore)
                .last("limit "+notice.getAllocationOfShares());
        List<BizBidEvaluation> result = super.list(resultQW);

        if(BeanUtils.isNotEmpty(result) && result.size()>0){
            int i = 1;
            for(BizBidEvaluation temp: result){
                if(i==1){
                    temp.setShareAllocationRate(notice.getAllocationRate1());
                }else if(i==2){
                    temp.setShareAllocationRate(notice.getAllocationRate2());
                }else if(i==3){
                    temp.setShareAllocationRate(notice.getAllocationRate3());
                }else if(i==4){
                    temp.setShareAllocationRate(notice.getAllocationRate4());
                }else {
                    temp.setShareAllocationRate(notice.getAllocationRate5());
                }
                i++;
            }
        }

        return result;
    }

    @Override
    public List<BizBidEvaluation> getCalibraDetailMaxScoreByIdPro(String noticeId) {
        ProjectApproval notice = projectApprovalManager.getById(noticeId);
        LambdaQueryWrapper<BizBidEvaluation> resultQW = new LambdaQueryWrapper<>();
        resultQW.eq(BizBidEvaluation::getNoticeId,noticeId)
                .eq(BizBidEvaluation::getIsDele,"0")
                .orderByDesc(BizBidEvaluation::getScore)
                .last("limit 1");
        List<BizBidEvaluation> result = super.list(resultQW);

        if(BeanUtils.isNotEmpty(result) && result.size()>0){
            for(BizBidEvaluation temp: result){
                temp.setShareAllocationRate(new BigDecimal("100"));
            }
        }

        return result;
    }

}
