package com.artfess.cgpt.bidding.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.QuotationTemplate;
import com.artfess.cgpt.material.model.BizMaterial;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/15 18:14
 */
public interface QuotationTemplateManager extends BaseManager<QuotationTemplate> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<QuotationTemplate> queryAllByPage(QueryFilter<QuotationTemplate> queryFilter);

    /**
     * 保存或更新数据
     * @param data
     */
    void saveOrUpdateData(QuotationTemplate data);

    /**
     * 根据ID查询详情
     * @param id 主键ID
     */
    QuotationTemplate dataById(String id);

    /**
     * 根据id集合删除
     * @param ids
     * @return
     */
    void removeByIds(List<String> ids);

}
