package com.artfess.cgpt.bidding.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BidDocuments;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/6/17 11:35
 */
public interface BidDocumentsManager extends BaseManager<BidDocuments> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BidDocuments> queryAllByPage(QueryFilter<BidDocuments> queryFilter);

    /**
     * 保存或更新
     * @param entity
     * @return
     */
    void saveOrUpdateEntity(BidDocuments entity);

    /**
     * 获取所有投标文件完成状态
     * @param entity
     * @return 0：未完成，1：已完成
     */
    Integer getAllSignStatus(BidDocuments entity);

    /**
     * 根据ids删除数据
     * @param ids
     * @return
     */
    void removeByIds(String ids);

    /**
     * 发起文件签署（推送电子合同）
     * @param fileId 附件id
     * @return
     */
    String sendDocSign(String fileId) throws Exception;

}
