package com.artfess.cgpt.bidding.dao;

import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 评标记录表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
public interface BizBidEvaluationDao extends BaseMapper<BizBidEvaluation> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBidEvaluation> queryAllByPage(IPage<BizBidEvaluation> convert2IPage, @Param("ew") Wrapper<BizBidEvaluation> convert2Wrapper);

    /**
     * 根据报价公司和立项查询总得分
     * @param quoOrgId 报价公司ID
     * @param noticeId 立项ID
     * @return
     */
    BigDecimal getTotalScore(@Param("quoOrgId") String quoOrgId,
                             @Param("noticeId")String noticeId);

    /**
     * 根据立项查询总得分排名
     * @param noticeId 立项ID
     * @return
     */
    List<BizBidEvaluation> groupScoreRank(@Param("noticeId")String noticeId);

    /**
     * 物资分页查询所有数据（关联查询采购立项明细表）
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBidEvaluation> queryNoticeDetailAllByPage(IPage<BizBidEvaluation> convert2IPage, @Param("ew") Wrapper<BizBidEvaluation> convert2Wrapper);

    /**
     * 项目分页查询所有数据（关联查询采购立项明细表）
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBidEvaluation> queryNoticeDetailAllByPagePro(IPage<BizBidEvaluation> convert2IPage, @Param("ew") Wrapper<BizBidEvaluation> convert2Wrapper);

}
