package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.manager.QuotationTemplateDetailManager;
import com.artfess.cgpt.bidding.model.QuotationTemplate;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description: 报价模版明细
 * @Author: Rong Tao
 * @Date: 2024/3/15 18:26
 */
@RestController
@RequestMapping("/quotationTemplateDetail/v1/")
@Api(tags="报价模版明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QuotationTemplateDetailController extends BaseController<QuotationTemplateDetailManager,QuotationTemplateDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<QuotationTemplateDetail>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<QuotationTemplateDetail> queryFilter){
        PageList<QuotationTemplateDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

}
