package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.manager.QuotationTemplateManager;
import com.artfess.cgpt.bidding.model.QuotationTemplate;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description: 报价模版
 * @Author: Rong Tao
 * @Date: 2024/3/15 18:16
 */
@RestController
@RequestMapping("/quotationTemplate/v1/")
@Api(tags="报价模版")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QuotationTemplateController extends BaseController<QuotationTemplateManager, QuotationTemplate> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<QuotationTemplate>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<QuotationTemplate> queryFilter){
        PageList<QuotationTemplate> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/saveOrUpdateData")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdateData(@RequestBody QuotationTemplate data) {
        baseService.saveOrUpdateData(data);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/dataById")
    @ApiOperation(value = "M-根据ID查询详情")
    public CommonResult<QuotationTemplate> dataById(@RequestParam("id") String id){
        QuotationTemplate result = baseService.dataById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-根据id集合删除")
    public CommonResult remove(@RequestParam List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }
    
}
