package com.artfess.cgpt.bidding.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.vo.EvaVo;
import com.artfess.cgpt.purchasing.model.MatApproval;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 评标记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Api(tags="评标记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RestController
@RequestMapping("/bidEvaluation/v1/")
public class BizBidEvaluationController extends BaseController<BizBidEvaluationManager, BizBidEvaluation> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizBidEvaluation>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizBidEvaluation> queryFilter) {
        PageList<BizBidEvaluation> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdate(@RequestBody BizBidEvaluation entity){
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true,"操作成功");
    }

//    @PostMapping("/saveByEva")
//    @ApiOperation(value = "M-评标（综合评标法）")
//    public CommonResult saveByEva(@RequestBody List<BizBidEvaluation> data){
//        baseService.saveByEva(data);
//        return new CommonResult<>(true,"操作成功");
//    }

//    @PostMapping("/bidEvaComprehensive")
//    @ApiOperation(value = "M-评标-综合评标法（以供应商评标）")
//    public CommonResult saveByEva(@RequestBody BizBidEvaluation entity){
//        baseService.saveByEva(entity);
//        return new CommonResult<>(true,"操作成功");
//    }
//
//    @PostMapping("/bidEvaComprehensiveMat")
//    @ApiOperation(value = "M-评标-综合评标法（以物料评标）")
//    public CommonResult saveByEvaMat(@RequestBody BizBidEvaluation entity){
//        baseService.saveByEvaMat(entity);
//        return new CommonResult<>(true,"操作成功");
//    }

//    @PostMapping("/bidEvaLowest")
//    @ApiOperation(value = "M-评标（最低评标法）")
//    public CommonResult bidEvaLowest(@RequestBody BizBiddingQuotation biddingQuotation){
//        baseService.bidEvaLowest(biddingQuotation);
//        return new CommonResult<>(true,"操作成功");
//    }

    @PostMapping("/choiceBidEvaLowest")
    @ApiOperation(value = "M-物资评标-最低评标法（以物料评标）")
    public CommonResult choiceBidEvaLowest(@RequestBody EvaVo evaVo){
        baseService.bidEvaLowest(evaVo);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/choiceBidEvaLowestPro")
    @ApiOperation(value = "M-项目评标-最低评标法（以物料评标）")
    public CommonResult choiceBidEvaLowestPro(@RequestBody EvaVo evaVo){
        baseService.choiceBidEvaLowestPro(evaVo);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/getCalibraDetailComprehensiveById")
    @ApiOperation(value = "M-定标管理-查看明细（综合-以物料评标）")
    public CommonResult<PageList<BizBidEvaluation>> getCalibraDetailComprehensive(@RequestBody QueryFilter<BizBidEvaluation> queryFilter) {
        PageList<BizBidEvaluation> result = baseService.getCalibraDetailComprehensive(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/getCalibraDetailById")
    @ApiOperation(value = "M-定标管理-查看明细（最低价评标法）")
    public CommonResult<PageList<BizBidEvaluation>> getCalibraDetailById(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizBidEvaluation> queryFilter) {
        PageList<BizBidEvaluation> result = baseService.getCalibraDetailById(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/exportCalibraDetail")
    @ApiOperation(value = "M-评标查看-导出明细（最低价评标法）")
    public CommonResult exportCalibraDetail(@RequestBody QueryFilter<BizBidEvaluation> queryFilter, HttpServletResponse response) throws IOException {
        baseService.exportCalibraDetail(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    @PostMapping("/getCalibraDetailMaxScoreById")
    @ApiOperation(value = "M-定标管理-查看明细（综合-以供应商评标）")
    public CommonResult<List<BizBidEvaluation>> getCalibraDetailMaxScoreById(@RequestParam("noticeId") String noticeId) {
        List<BizBidEvaluation> result = baseService.getCalibraDetailMaxScoreById(noticeId);
        return new CommonResult<>(true, "查询成功", result);
    }

}
