package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.manager.BiddingQuotationTemplateDetailDataManager;
import com.artfess.cgpt.bidding.model.BidDocuments;
import com.artfess.cgpt.bidding.model.BiddingQuotationTemplateDetailData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:报价记录_报价模版明细关联数据表
 * @Author: Rong Tao
 * @Date: 2024/6/26 18:43
 */
@RestController
@RequestMapping("/biddingQuotationTemplateDetailData/v1/")
@Api(tags="报价记录_报价模版明细关联数据表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BiddingQuotationTemplateDetailDataController extends BaseController<BiddingQuotationTemplateDetailDataManager, BiddingQuotationTemplateDetailData> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BiddingQuotationTemplateDetailData>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BiddingQuotationTemplateDetailData> queryFilter) {
        PageList<BiddingQuotationTemplateDetailData> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
