package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BidDocumentsManager;
import com.artfess.cgpt.bidding.model.BidDocuments;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.vo.QuoVo;
import com.artfess.cgpt.project.model.ProjectApproval;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/6/17 11:37
 */
@RestController
@RequestMapping("/bidDocuments/v1/")
@Api(tags="投标文件关联表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BidDocumentsController extends BaseController<BidDocumentsManager, BidDocuments> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BidDocuments>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BidDocuments> queryFilter) {
        PageList<BidDocuments> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation(value = "M-保存或更新",httpMethod = "POST")
    public CommonResult saveOrUpdateEntity(@RequestBody BidDocuments entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

        @PostMapping("/getAllSignStatus")
    @ApiOperation(value = "M-获取所有投标文件完成状态（0：未完成，1：已完成）",httpMethod = "POST")
    public CommonResult getAllSignStatus(@RequestBody BidDocuments entity) {
        Integer result = baseService.getAllSignStatus(entity);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/removeByIds")
    @ApiOperation(value = "M-根据ids删除数据",httpMethod = "POST")
    public CommonResult removeByIds(@RequestParam("ids") String ids) {
        baseService.removeByIds(ids);
        return new CommonResult(true,"操作成功");
    }

    /**
     * 发起文件签署（推送电子合同）
     * @param fileId 附件id
     * @return 签署链接
     */
    @PostMapping("/sendDocSign")
    @ApiOperation(value = "M-发起文件签署（推送电子合同）")
    public CommonResult sendDocSign(@RequestParam("fileId") String fileId) throws Exception {
        if(BeanUtils.isEmpty(fileId)){
            return new CommonResult<>(false,"请选择数据");
        }
        String url = baseService.sendDocSign(fileId);
        return new CommonResult(true,"操作成功",url);
    }

}
