/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.project.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.project.dao.UserParticipationDao;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.manager.UserParticipationQualificationLabelManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.project.model.UserParticipationQualificationLabel;
import com.artfess.cgpt.purchasing.manager.ApprovalInviteVendorManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalQualificationManager;
import com.artfess.cgpt.purchasing.model.ApprovalInviteVendor;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalQualification;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.manager.BizSupplierEnterpriseManager;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserParticipationManagerImpl
extends BaseManagerImpl<UserParticipationDao, UserParticipation>
implements UserParticipationManager {
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private UserParticipationQualificationLabelManager userParticipationQualificationLabelManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private ApprovalInviteVendorManager approvalInviteVendorManager;
    @Autowired
    private BizSupplierEnterpriseManager supplierEnterpriseManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private BizContractManager contractManager;
    @Autowired
    private BizRegistrationOrderManager registrationOrderManager;
    @Autowired
    private ProjectApprovalManager projectApprovalManager;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private MatApprovalQualificationManager approvalQualificationManager;

    @Override
    public List<UserParticipation> getNoRefundData() {
        List<UserParticipation> result = ((UserParticipationDao)this.baseMapper).getNoRefundData();
        return result;
    }

    @Override
    public List<UserParticipation> queryList(Wrapper<UserParticipation> wrapper) {
        List<UserParticipation> result = ((UserParticipationDao)this.baseMapper).queryList(wrapper);
        return result;
    }

    @Override
    public PageList<UserParticipation> queryAllByPage(QueryFilter<UserParticipation> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<UserParticipation> result = ((UserParticipationDao)this.baseMapper).queryAllByPage((IPage<UserParticipation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<UserParticipation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public UserParticipation getDataById(String id) {
        UserParticipation result = (UserParticipation)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper qualificationLabelQW = new LambdaQueryWrapper();
        qualificationLabelQW.eq(MatApprovalQualification::getProjectId, (Object)result.getNoticeId());
        result.setMatApprovalQualificationList(this.approvalQualificationManager.list((Wrapper)qualificationLabelQW));
        QueryFilter qualificationQF = QueryFilter.build();
        qualificationQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
        qualificationQF.addFilter("a.USER_PARTICIPATION_ID_", (Object)id, QueryOP.EQUAL);
        result.setQualificationLabelList(this.userParticipationQualificationLabelManager.queryQualificationPage((QueryFilter<UserParticipationQualificationLabel>)qualificationQF).getRows());
        if (BeanUtils.isNotEmpty(result.getQualificationLabelList()) && result.getQualificationLabelList().size() > 0) {
            result.getQualificationLabelList().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
        }
        return result;
    }

    @Override
    public PageList<UserParticipation> queryByPage(QueryFilter<UserParticipation> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("COMPANY_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        IPage<UserParticipation> result = ((UserParticipationDao)this.baseMapper).queryAllByPage((IPage<UserParticipation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<UserParticipation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<UserParticipation> pageRegistraAndBid(QueryFilter<UserParticipation> queryFilter) {
        Integer round = 1;
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equals("round")) continue;
                round = (Integer)qf.getValue();
                qf.setProperty("1");
                qf.setValue((Object)"1");
                break;
            }
        }
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<UserParticipation> result = ((UserParticipationDao)this.baseMapper).queryAllByPage((IPage<UserParticipation>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<UserParticipation>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (UserParticipation userPart : records) {
                LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)quoQW.eq(BizBiddingQuotation::getQuotationRounds, (Object)round)).eq(BizBiddingQuotation::getNoticeId, (Object)userPart.getNoticeId())).eq(BizBiddingQuotation::getNoticeType, (Object)userPart.getNoticeType())).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)userPart.getCompanyId());
                if (this.quotationManager.count((Wrapper)quoQW) > 0) {
                    userPart.setIsQuo(1);
                    continue;
                }
                userPart.setIsQuo(0);
            }
        }
        return new PageList(result);
    }

    @Override
    @Transactional
    public void participate(UserParticipation entity) {
        BizModel notice;
        this.verifyPermissions(entity);
        if (entity.getNoticeType() == 2 ? (notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)entity.getNoticeId())))).getHasQualification() == 2 : (notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())))).getHasQualification() == 2) {
            throw new BaseException("\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u70b9\u51fb\u53c2\u4e0e\u5e76\u4e0a\u4f20\u8d44\u8d28");
        }
        if (BeanUtils.isEmpty((Object)entity.getType())) {
            entity.setType(1);
        }
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(UserParticipation::getNoticeId, (Object)entity.getNoticeId())).eq(UserParticipation::getNoticeType, (Object)entity.getNoticeType())).eq(UserParticipation::getType, (Object)entity.getType())).eq(BizModel::getIsDele, (Object)"0")).last("limit 1");
        UserParticipation history = (UserParticipation)((Object)((UserParticipationDao)this.baseMapper).selectOne((Wrapper)hisQW));
        if (BeanUtils.isEmpty((Object)((Object)history))) {
            IUser user = ContextUtil.getCurrentUser();
            entity.setUserId(user.getUserId());
            entity.setUserAccount(user.getAccount());
            entity.setUserName(user.getFullname());
            if (BeanUtils.isNotEmpty((Object)user.getMobile())) {
                entity.setUserPhone(user.getMobile());
            }
            entity.setParticipationDate(LocalDateTime.now());
            IGroup org = ContextUtil.getCurrentGroup();
            if (BeanUtils.isNotEmpty((Object)org)) {
                entity.setCompanyId(org.getGroupId());
                entity.setCompanyCode(org.getGroupCode());
                entity.setCompanyName(org.getName());
            }
            if (BeanUtils.isNotEmpty((Object)entity.getDocumentFee()) && entity.getDocumentFee().compareTo(BigDecimal.ZERO) > 0) {
                UserParticipation docFeeData = new UserParticipation();
                try {
                    BeanUtils.copyNotNullProperties((Object)((Object)docFeeData), (Object)((Object)entity));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    throw new BaseException("\u751f\u6210\u6807\u4e66\u8d39\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                }
                docFeeData.setStatus(3);
                docFeeData.setPrice(entity.getDocumentFee());
                docFeeData.setType(2);
                super.save((Object)docFeeData);
                entity.setDocumentFeeId(docFeeData.getId());
                if (BeanUtils.isEmpty((Object)entity.getPrice()) || entity.getPrice().compareTo(BigDecimal.ZERO) == 0) {
                    entity.setStatus(4);
                }
            }
            super.save((Object)entity);
        } else {
            history.setNoticeTitle(entity.getNoticeTitle());
            history.setStatus(entity.getStatus());
            super.updateById((Object)history);
        }
    }

    @Override
    @Transactional
    public String qualificationsParticipate(UserParticipation entity) {
        this.verifyPermissions(entity);
        if (BeanUtils.isEmpty((Object)entity.getType())) {
            entity.setType(1);
        }
        entity.setStatus(2);
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
        List<Accessory> accessoryList = entity.getAccessoryList();
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(UserParticipation::getNoticeId, (Object)entity.getNoticeId())).eq(UserParticipation::getNoticeType, (Object)entity.getNoticeType())).eq(UserParticipation::getType, (Object)entity.getType())).eq(BizModel::getIsDele, (Object)"0")).last("limit 1");
        UserParticipation history = (UserParticipation)((Object)((UserParticipationDao)this.baseMapper).selectOne((Wrapper)hisQW));
        if (BeanUtils.isEmpty((Object)((Object)history))) {
            IUser user = ContextUtil.getCurrentUser();
            entity.setUserId(user.getUserId());
            entity.setUserAccount(user.getAccount());
            entity.setUserName(user.getFullname());
            if (BeanUtils.isNotEmpty((Object)user.getMobile())) {
                entity.setUserPhone(user.getMobile());
            }
            entity.setParticipationDate(LocalDateTime.now());
            IGroup org = ContextUtil.getCurrentGroup();
            if (BeanUtils.isNotEmpty((Object)org)) {
                entity.setCompanyId(org.getGroupId());
                entity.setCompanyCode(org.getGroupCode());
                entity.setCompanyName(org.getName());
            }
            if (BeanUtils.isNotEmpty((Object)entity.getDocumentFee()) && entity.getDocumentFee().compareTo(BigDecimal.ZERO) > 0) {
                UserParticipation docFeeData = new UserParticipation();
                try {
                    BeanUtils.copyNotNullProperties((Object)((Object)docFeeData), (Object)((Object)entity));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    throw new BaseException("\u751f\u6210\u6807\u4e66\u8d39\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                }
                docFeeData.setPrice(entity.getDocumentFee());
                docFeeData.setType(2);
                super.save((Object)docFeeData);
                entity.setDocumentFeeId(docFeeData.getId());
            }
            super.save((Object)entity);
        } else {
            entity.setId(history.getId());
            history.setNoticeTitle(entity.getNoticeTitle());
            history.setStatus(entity.getStatus());
            super.updateById((Object)history);
            this.accessoryService.removeBySourceId(history.getId());
            LambdaQueryWrapper partQualificationLabelQW = new LambdaQueryWrapper();
            partQualificationLabelQW.eq(UserParticipationQualificationLabel::getUserParticipationId, (Object)entity.getId());
            this.userParticipationQualificationLabelManager.remove((Wrapper)partQualificationLabelQW);
        }
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
        if (BeanUtils.isNotEmpty(qualificationLabelList) && qualificationLabelList.size() > 0) {
            ArrayList<UserParticipationQualificationLabel> participationQualificationLabelList = new ArrayList<UserParticipationQualificationLabel>();
            for (BizQualificationLabel label : qualificationLabelList) {
                if (BeanUtils.isEmpty((Object)label.getId())) {
                    this.qualificationLabelManager.saveOrUpdateEntity(label);
                }
                UserParticipationQualificationLabel temp = new UserParticipationQualificationLabel();
                temp.setUserParticipationId(entity.getId());
                temp.setQualificationLabelId(label.getId());
                participationQualificationLabelList.add(temp);
            }
            this.userParticipationQualificationLabelManager.saveBatch(participationQualificationLabelList);
        }
        return entity.getId();
    }

    @Override
    @Transactional
    public void modifyStatus(String ids, String status) {
        if (status.equals("5")) {
            LambdaQueryWrapper participationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)participationQW.select(new SFunction[]{UserParticipation::getNoticeCode}).in(UserParticipation::getId, Arrays.asList(ids.split(",")))).eq(UserParticipation::getStatus, (Object)1)).eq(UserParticipation::getType, (Object)1)).gt(UserParticipation::getPrice, (Object)0)).eq(BizModel::getIsDele, (Object)"0");
            List objectList = super.listObjs((Wrapper)participationQW);
            if (BeanUtils.isNotEmpty((Object)objectList) && objectList.size() > 0) {
                List collect = objectList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("\u53d6\u6d88\u5931\u8d25\uff1a\u9879\u76ee\u7f16\u53f7\u3010" + String.join((CharSequence)",", collect) + "\u3011\u5df2\u7f34\u7eb3\u4fdd\u8bc1\u91d1\uff0c\u8bf7\u7b49\u5f85\u6210\u4ea4\u540e\u9000\u8fd8\u4fdd\u8bc1\u91d1");
            }
        }
        LambdaUpdateWrapper participationUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)participationUW.set(UserParticipation::getStatus, (Object)status)).in(UserParticipation::getId, Arrays.asList(ids.split(",")))).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)participationUW);
    }

    @Override
    @Transactional
    public void modifyStatusByNoticeId(String noticeIds, String status) {
        if (status.equals("5")) {
            LambdaQueryWrapper participationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)participationQW.select(new SFunction[]{UserParticipation::getNoticeCode}).eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).in(UserParticipation::getNoticeId, Arrays.asList(noticeIds.split(",")))).eq(UserParticipation::getStatus, (Object)1)).eq(UserParticipation::getType, (Object)1)).gt(UserParticipation::getPrice, (Object)0)).eq(BizModel::getIsDele, (Object)"0");
            List objectList = super.listObjs((Wrapper)participationQW);
            if (BeanUtils.isNotEmpty((Object)objectList) && objectList.size() > 0) {
                List collect = objectList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                throw new BaseException("\u53d6\u6d88\u5931\u8d25\uff1a\u9879\u76ee\u7f16\u53f7\u3010" + String.join((CharSequence)",", collect) + "\u3011\u5df2\u7f34\u7eb3\u4fdd\u8bc1\u91d1\uff0c\u8bf7\u7b49\u5f85\u6210\u4ea4\u540e\u9000\u8fd8\u4fdd\u8bc1\u91d1");
            }
        }
        LambdaUpdateWrapper participationUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)participationUW.set(UserParticipation::getStatus, (Object)status)).eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).in(UserParticipation::getNoticeId, Arrays.asList(noticeIds.split(",")))).eq(UserParticipation::getType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)participationUW);
    }

    @Override
    public void refundWinBidBond() {
        List<UserParticipation> noRefundData = ((UserParticipationDao)this.baseMapper).getNoRefundData();
        if (BeanUtils.isNotEmpty(noRefundData) && noRefundData.size() > 0) {
            for (UserParticipation userPart : noRefundData) {
                MatApproval notice;
                Integer noSignContrCount = this.contractManager.getNoSignContrCount(userPart.getNoticeId(), userPart.getCompanyId());
                if (noSignContrCount != 0 || userPart.getNoticeType() != 1 || !BeanUtils.isNotEmpty((Object)(notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)userPart.getNoticeId())))).getBond()) || notice.getBond().compareTo(BigDecimal.ZERO) <= 0 || BeanUtils.isEmpty((Object)userPart.getRegistrationOrderId())) continue;
                try {
                    this.registrationOrderManager.refundBond(userPart);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u9000\u8fd8\u5df2\u7b7e\u8ba2\u5408\u540c\u6210\u4ea4\u4f9b\u5e94\u5546\u7684\u4fdd\u8bc1\u91d1\u63a5\u53e3\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    void verifyPermissions(UserParticipation entity) {
        BizModel notice;
        Integer releaseMethod = 1;
        String procureOrgId = "";
        LocalDateTime responseEndTime = null;
        if (entity.getNoticeType() == 2) {
            notice = (ProjectApproval)((Object)this.projectApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
            releaseMethod = notice.getReleaseMethod();
            procureOrgId = notice.getProcureOrgId();
            responseEndTime = notice.getResponseTimeDeadline();
        } else {
            notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
            releaseMethod = notice.getReleaseMethod();
            procureOrgId = notice.getProcureOrgId();
            responseEndTime = notice.getResponseTimeDeadline();
        }
        if (BeanUtils.isNotEmpty((Object)responseEndTime) && responseEndTime.isBefore(LocalDateTime.now())) {
            throw new BaseException("\u53c2\u4e0e\u5931\u8d25\uff1a\u54cd\u5e94\u65f6\u95f4\u5df2\u622a\u6b62");
        }
        if (releaseMethod == 2) {
            LambdaQueryWrapper inviteVendorQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)inviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId, (Object)entity.getNoticeId())).eq(ApprovalInviteVendor::getProjectApprovalType, (Object)entity.getNoticeType())).eq(ApprovalInviteVendor::getVendorId, (Object)ContextUtil.getCurrentOrgId());
            if (this.approvalInviteVendorManager.count((Wrapper)inviteVendorQW) == 0) {
                throw new BaseException("\u8be5\u7acb\u9879\u53ea\u5141\u8bb8\u88ab\u9080\u8bf7\u7684\u4f9b\u5e94\u5546\u624d\u80fd\u53c2\u4e0e");
            }
        }
    }
}

