import { dictionaryEscape, getDictionaryByCode } from '@/utils/dictionary'

interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = []
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '申请人',
            prop: 'changeInitiatorName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '审核状态',
            prop: 'approvalResult',
            type: 'select',
            options: [
                { name: '未审核', value: '-1' },
                { name: '通过', value: '1' },
                { name: '驳回', value: '0' },
            ],
            value: '',
            span: 4
        },
        {
            title: '申请时间',
            prop: 'changeInitiatorStartDate',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'supplierName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '变更原因',
            prop: 'changeReason',
            minWidth: 250,
            sortable: true
        },

        {
            title: '申请人',
            prop: 'changeInitiatorName',
            minWidth: 120,
            sortable: true
        },
        {
            title: '审核状态',
            prop: 'approvalResult',
            minWidth: 120,
            render:true,
            sortable: true
        },
        {
            title: '申请时间',
            prop: 'changeInitiatorStartDate',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
