/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.vo.ArchivesManagerVo;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.manager.ExamUserEvaluationDetailManager;
import com.artfess.examine.manager.ExamUserEvaluationManager;
import com.artfess.examine.model.ExamUserEvaluation;
import com.artfess.examine.model.ExamUserEvaluationDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bad\u7ec3\u6570\u636e-\u6863\u6848\u7ba1\u7406"})
@RequestMapping(value={"/biz/archives/"})
@ApiGroup(group={"group_biz"})
public class ArchivesManagerController {
    private static final Logger log = LoggerFactory.getLogger(ArchivesManagerController.class);
    @Autowired
    private ExamUserEvaluationManager userEvaluationManager;
    @Autowired
    private ExamUserEvaluationDetailManager userEvaluationDetailManager;

    @PostMapping(value={"/personArchives"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e2a\u4eba\u6863\u6848")
    public PageList<ExamUserEvaluationDetail> personArchives(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        return this.userEvaluationDetailManager.findByPage(queryFilter);
    }

    @PostMapping(value={"/positionArchives"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5c97\u4f4d\u6863\u6848")
    public PageList<ArchivesManagerVo> positionArchives(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return this.userEvaluationManager.positionArchives(queryFilter);
    }

    @PostMapping(value={"/orgArchives"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5355\u4f4d\u6863\u6848")
    public PageList<ArchivesManagerVo> orgArchives(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return this.userEvaluationManager.orgArchives(queryFilter);
    }

    @PostMapping(value={"/subjectArchives"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bfe\u76ee\u6863\u6848")
    public PageList<ArchivesManagerVo> subjectArchives(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter) {
        return this.userEvaluationManager.subjectArchives(queryFilter);
    }

    @PostMapping(value={"/subjectArchives/exportWord"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u8bfe\u76ee\u6863\u6848")
    public void subjectArchivesExport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response) {
        this.userEvaluationManager.subjectArchivesExport(queryFilter, response);
    }

    @PostMapping(value={"/orgArchives/exportWord"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5355\u4f4d\u6863\u6848")
    public void orgArchivesExport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response) {
        this.userEvaluationManager.orgArchivesExport(queryFilter, response);
    }

    @PostMapping(value={"/positionArchives/exportWord"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5c97\u4f4d\u6863\u6848")
    public void positionArchivesExport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluation> queryFilter, HttpServletResponse response) {
        this.userEvaluationManager.positionArchivesExport(queryFilter, response);
    }

    @PostMapping(value={"/personArchives/exportWord"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u4e2a\u4eba\u6863\u6848")
    public void personArchivesExport(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluationDetail> queryFilter, HttpServletResponse response) {
        this.userEvaluationDetailManager.personArchivesExport(queryFilter, response);
    }

    @PostMapping(value={"/userStudyAnalyse"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4eba\u5458\u5b66\u4e60\u60c5\u51b5\u5206\u6790")
    public PageList<UserExamVo> userStudyAnalyse(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<ExamUserEvaluationDetail> queryFilter) {
        return this.userEvaluationDetailManager.userStudyAnalyse(queryFilter);
    }
}

