package com.artfess.uc.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import java.time.LocalDateTime;

/**
* 假期时间
* <pre>
* 描述：假期时间 实体对象
* 构建组：x7
* 作者:qiuxd
* 邮箱:qiuxd@jee-soft.cn
* 日期:2020-08-04 11:04:35
* 版权：广州宏天软件股份有限公司
* </pre>
*/
@TableName("uc_holiday_time")
@ApiModel(value = "HolidayTime",description = "假期时间")
public class HolidayTime extends BaseModel<HolidayTime>{

    public static final Short HOLIDAY = 0;
    public static final Short MAKE_UP_DAY = 1;

   private static final long serialVersionUID = 1L;
   @XmlTransient
   @TableId("ID_")
   @ApiModelProperty(value="主键")
   protected String id;

   @XmlAttribute(name = "startTime")
   @TableField("START_TIME_")
   @ApiModelProperty(value="假期开始时间")
   protected LocalDateTime startTime;

   @XmlAttribute(name = "endTime")
   @TableField("END_TIME_")
   @ApiModelProperty(value="假期结束时间")
   protected LocalDateTime endTime;

   @XmlAttribute(name = "holidayId")
   @TableField("HOLIDAY_ID_")
   @ApiModelProperty(value="假期ID")
   protected String holidayId;

   @XmlAttribute(name = "type")
   @TableField("TYPE_")
   @ApiModelProperty(value = "假期类型：0假期 1补班")
   protected Short type;


   public void setId(String id) {
       this.id = id;
   }

   /**
    * 返回 主键
    * @return
    */
   public String getId() {
       return this.id;
   }
   public void setStartTime(LocalDateTime startTime) {
       this.startTime = startTime;
   }

   /**
    * 返回 假期开始时间
    * @return
    */
   public LocalDateTime getStartTime() {
       return this.startTime;
   }
   public void setEndTime(LocalDateTime endTime) {
       this.endTime = endTime;
   }

   /**
    * 返回 假期结束时间
    * @return
    */
   public LocalDateTime getEndTime() {
       return this.endTime;
   }
   public void setHolidayId(String holidayId) {
       this.holidayId = holidayId;
   }

   /**
    * 返回 假期ID
    * @return
    */
   public String getHolidayId() {
       return this.holidayId;
   }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    /**
    * @see Object#toString()
    */
   public String toString() {
       return new ToStringBuilder(this)
       .append("id", this.id)
       .append("startTime", this.startTime)
       .append("endTime", this.endTime)
       .append("holidayId", this.holidayId)
       .toString();
   }
}
