package com.artfess.uc.manager;

import com.artfess.base.model.CommonResult;
import com.artfess.uc.params.org.OaAsyncObject;
import com.artfess.uc.params.user.UserImportVo;
import org.springframework.web.multipart.MultipartFile;

/**
 *
 * <pre>
 * 描述：用户表 处理接口
 * 构建组：x5-bpmx-platform
 * 作者:ray
 * 邮箱:zhangyg@jee-soft.cn
 * 日期:2016-06-30 10:26:50
 * 版权：广州宏天软件有限公司
 * </pre>
 */
public interface UserImportManager{


	/**
	 * 导入Excel用户组织
	 * @param file
	 * @param demCode
	 * @param repeatConver 组织岗位等不一致时是否覆盖（覆盖则删除旧的组织、岗位关系，绑定新的，不覆盖，则只新增）
	 * @return
	 * @throws Exception
	 */
	CommonResult<String> importExcelUser(MultipartFile file,String demCode,boolean repeatConver);

	/**
	 * 导入用户组织关系
	 * @param file
	 * @return
	 * @throws Exception
	 */
	CommonResult<String> importZipUser(MultipartFile file,UserImportVo importVo)  throws Exception ;

	/**
	 *
	 * @param oaAsyncObject
	 * @return
	 * @throws Exception
	 */
	CommonResult<String> syncSoap(OaAsyncObject oaAsyncObject,String ip) throws Exception ;

	/**
 	 * AD域同步
 	 * @param action 全量：“all”,其他字符为增量
 	 * @param ip 全量：操作ip
 	 * @return
 	 * @throws Exception
 	 */
 	CommonResult<String> syncADUsers(String action,String ip)throws Exception;
}
