/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.helper.identity.IConditionCheck;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.api.plugin.core.context.UserCalcPluginContext;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.persistence.dao.BpmAgentConditionDao;
import com.artfess.bpm.persistence.manager.BpmAgentConditionManager;
import com.artfess.bpm.persistence.model.BpmAgentCondition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmAgentConditionManager")
public class BpmAgentConditionManagerImpl
extends BaseManagerImpl<BpmAgentConditionDao, BpmAgentCondition>
implements BpmAgentConditionManager {
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    BpmAgentConditionDao bpmAgentConditionDao;

    @Override
    public boolean checkCondition(BpmDelegateTask delegateTask, BpmAgentCondition con) {
        if (BeanUtils.isEmpty((Object)con.getCondition())) {
            return true;
        }
        BpmUserCalcPluginSession bpmUserCalcPluginSession = ((BpmPluginSessionFactory)AppUtil.getBean(BpmPluginSessionFactory.class)).buildBpmUserCalcPluginSession(delegateTask);
        UserAssignRule userAgentRule = new UserAssignRule();
        ArrayList<UserCalcPluginContext> calcPluginContextList = new ArrayList<UserCalcPluginContext>();
        userAgentRule.setCalcPluginContextList(calcPluginContextList);
        userAgentRule.setCondition(con.getCondition().toString());
        return BpmAgentConditionManagerImpl.isRuleValid(userAgentRule, bpmUserCalcPluginSession);
    }

    private static boolean isRuleValid(UserAssignRule rule, BpmUserCalcPluginSession pluginSession) {
        IConditionCheck conditionCheck = (IConditionCheck)AppUtil.getBean((String)"userConditionCheck");
        return conditionCheck.check(rule.getCondition(), rule.getConditionMode(), pluginSession);
    }

    @Override
    @Transactional
    public void removeBySettingId(String pk) {
        ((BpmAgentConditionDao)this.baseMapper).removeBySettingId(pk);
    }

    @Override
    public List<BpmAgentCondition> getBySettingId(String id) {
        return ((BpmAgentConditionDao)this.baseMapper).getBySettingId(id);
    }
}

